package com.gtis.plat.service;

import com.gtis.plat.vo.EcExceptionVo;

import java.util.HashMap;
import java.util.List;

public interface SysExceptionService {

    // 根据instanceID获取EXCEPTION信息
    public List<EcExceptionVo> getEcExceptionByInstanceId(String instanceId);

    // 保存异常信息
    public void saveException(EcExceptionVo exception);

    // 更新异常信息
    public void updateException(EcExceptionVo exception);

    // 根据ActivityID获取 EXCEPTION 信息
    public List<EcExceptionVo> getEcExceptionByActivityId(String activityId);

    //根据人员统计
    public List<HashMap> statUserException(HashMap map);

    //根据部门 统计
    public List<HashMap> statOrganException(HashMap map);

    //查询所有部门ID 和部门NAME
    public List<HashMap> queryOrgan();

    //统计详细
    public List<HashMap> getDetailStat(HashMap condition);

    /**
     * 获得活动异常列表
     *
     * @param workflowInstanceId
     * @return
     */
    public List<HashMap> getActivityExceptionList(String workflowInstanceId);

    /**
     * 删除异常
     *
     * @param exceptionId 异常主键
     */
    public void updateExceptionStatus(HashMap statusMap);

    /**
     * 获得异常列表
     *
     * @param workflowInstanceId
     * @param activityId
     * @param exceptionType
     * @param userId
     * @return
     */
    public List<HashMap> getEcExceptionList(String workflowInstanceId, String activityId, int exceptionType, String userId);
}
