package com.gtis.ibatis;


import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

import javax.sql.DataSource;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

/**
 * 使用ibatis的基础抽象类
 *
 * @author C4ISR
 */
public abstract class BaseDaoiBatisSupport implements InitializingBean {

    private SqlExecutor sqlExecutor;
    protected Log log = LogFactory.getLog(getClass());
    private SqlMapClientTemplate sqlMapClientTemplate = new SqlMapClientTemplate();

    public SqlMapClientTemplate getSqlMapClientTemplate() {
        return this.sqlMapClientTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.sqlMapClientTemplate.setDataSource(dataSource);
    }

    @Autowired
    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClientTemplate.setSqlMapClient(sqlMapClient);
    }

    public SqlExecutor getSqlExecutor() {
        return sqlExecutor;
    }

    /**
     * 使用Spring的依赖注入
     *
     * @param sqlExecutor sqlExecutor
     */
    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        SqlMapClientImpl client = (SqlMapClientImpl) getSqlMapClientTemplate().getSqlMapClient();
        SqlMapExecutorDelegate delegate = client.getDelegate();
        try {
            ReflectUtil.setFieldValue(delegate, "sqlExecutor", SqlExecutor.class, sqlExecutor);
            log.info("[iBATIS] success set ibatis SqlMapClient.sqlExecutor = " + sqlExecutor.getClass().getName());
        } catch (Exception e) {
            log.info("[iBATIS] error,cannot set ibatis SqlMapClient.sqlExecutor = " + sqlExecutor.getClass().getName() + " cause:" + e);
        }
    }

    /**
     * 使用Spring的依赖注入,是否进行分页操作
     *
     * @param enableLimit enableLimit
     */
    public void setEnableLimit(boolean enableLimit) {
        if (sqlExecutor instanceof SplitSqlExecutor) {
            ((SplitSqlExecutor) sqlExecutor).setEnableLimit(enableLimit);
        }
    }

    /**
     * 初始化操作
     *
     * @throws Exception
     */
//	public void initialize() throws Exception {
//		if (sqlExecutor != null) {
//			SqlMapClient sqlMapClient = getSqlMapClientTemplate()
//					.getSqlMapClient();
//			if (sqlMapClient instanceof ExtendedSqlMapClient) {
//				ReflectUtil.setFieldValue(((ExtendedSqlMapClient) sqlMapClient)
//                        .getDelegate(), "sqlExecutor", SqlExecutor.class,
//                        sqlExecutor);
//			}
//		}
//	}
    public List queryForListOrderby(String selectQuery, Object parameterObject, int skipSize, int pageSize) {
        String orderByQuery = OrderByStatementUtil.getOrderByStatementId(selectQuery);

        SqlMapClient sqlMapClient = getSqlMapClientTemplate().getSqlMapClient();
        if (sqlMapClient instanceof ExtendedSqlMapClient) {
            SqlMapExecutorDelegate delegate = ((ExtendedSqlMapClient) sqlMapClient)
                    .getDelegate();
            try {
                delegate.getMappedStatement(orderByQuery);
            } catch (SqlMapException e) {
                delegate.addMappedStatement(OrderByStatementUtil
                        .createOrderByStatement(delegate
                                .getMappedStatement(selectQuery)));
            }
        }
        return getSqlMapClientTemplate().queryForList(
                OrderByStatementUtil.getOrderByStatementId(selectQuery),
                parameterObject, skipSize, pageSize);
    }

    /**
     * 获取记录的完整数量,主要应用于分页查询
     *
     * @param selectQuery     selectQuery
     * @param parameterObject parameterObject
     * @return total
     */
    public int getObjectTotal(String selectQuery, Object parameterObject) {
        prepareCountQuery(selectQuery);
        // 这里可以进行进一步的完善
        return Integer.parseInt(getSqlMapClientTemplate().queryForObject(
                CountStatementUtil.getCountStatementId(selectQuery),
                parameterObject).toString());
    }

    protected void prepareCountQuery(String selectQuery) {
        String countQuery = CountStatementUtil.getCountStatementId(selectQuery);
        if (log.isDebugEnabled()) {
            log.debug("Convert " + selectQuery + " to " + countQuery);
        }
        SqlMapClient sqlMapClient = getSqlMapClientTemplate().getSqlMapClient();
        if (sqlMapClient instanceof ExtendedSqlMapClient) {
            SqlMapExecutorDelegate delegate = ((ExtendedSqlMapClient) sqlMapClient)
                    .getDelegate();
            try {
                delegate.getMappedStatement(countQuery);
            } catch (SqlMapException e) {
                delegate.addMappedStatement(CountStatementUtil
                        .createCountStatement(delegate
                                .getMappedStatement(selectQuery)));
            }
        }
    }

    static class ReflectUtil {

        private static final Log logger = LogFactory.getLog(ReflectUtil.class);

        public static void setFieldValue(Object target, String fname, Class ftype,
                                         Object fvalue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            if (target == null
                    || fname == null
                    || "".equals(fname)
                    || (fvalue != null && !ftype.isAssignableFrom(fvalue.getClass()))) {
                return;
            }

            Class clazz = target.getClass();
            try {
                Method method = clazz.getDeclaredMethod("set"
                        + Character.toUpperCase(fname.charAt(0))
                        + fname.substring(1), ftype);
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                method.invoke(target, fvalue);
            } catch (Exception me) {
                Field field = clazz.getDeclaredField(fname);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(target, fvalue);
            }
        }
    }
}
