package com.gtis.exchange.service;

import com.gtis.exchange.vo.ReceiverVo;

import javax.activation.DataHandler;
import java.util.Map;

/**
 * 交换系统服务封装接口
 *
 * @author <a href="mailto:jibo1024@gmail.com">jibo</a>
 * @version V1.0, 2010-2-24
 */
public interface IExchangeService {

    /**
     * 接受文件总数
     *
     * @return
     */
    @Deprecated
    int getRecievedDataCount();

    /**
     * 根据key接受文件总数
     *
     * @return
     * @params key
     */
    int getRecievedDataCount(String key);

    /**
     * 获得待收文件数
     *
     * @return
     */
    @Deprecated
    int getRecievedDataCount4Ready();

    /**
     * 根据key获得待收文件总数
     *
     * @return
     * @params key
     */
    int getRecievedDataCount4Ready(String key);

    /**
     * 获取指定分页的文件信息
     *
     * @param pageIndex
     * @param pageSize
     * @return
     */
    @Deprecated
    String getRecievedDataXml(int pageIndex, int pageSize);

    /**
     * 根据key获取指定分页的文件信息
     *
     * @param pageIndex
     * @param pageSize
     * @param key
     * @return
     */
    String getRecievedDataXml(int pageIndex, int pageSize, String key);

    /**
     * 获取待收指定分页的文件信息
     *
     * @param pageIndex
     * @param pageSize
     * @return
     */
    @Deprecated
    String getRecievedDataXml4Ready(int pageIndex, int pageSize);

    /**
     * 根据key获取待收指定分页的文件信息
     *
     * @param pageIndex
     * @param pageSize
     * @param key
     * @return
     */
    String getRecievedDataXml4Ready(int pageIndex, int pageSize, String key);

    /**
     * 收文的详细信息
     *
     * @param taskID
     * @return
     */
    @Deprecated
    String getRecievedData(String taskID);

    /**
     * 根据key收文的详细信息
     *
     * @param taskID
     * @param key
     * @return
     */
    String getRecievedData(String taskID, String key);

    /**
     * 获得一条以fileIdentifier为文件别名的附件DataHandler引用以操作文件资源
     *
     * @param actID
     * @param fileIdentifier
     * @return
     */
    @Deprecated
    DataHandler downloadFile(String actID, String fileIdentifier);

    /**
     * 根据key
     * 获得一条以fileIdentifier为文件别名的附件DataHandler引用以操作文件资源
     *
     * @param actID
     * @param fileIdentifier
     * @param key
     * @return
     */
    DataHandler downloadFile(String actID, String fileIdentifier, String key);

    /**
     * 下载任务附件
     *
     * @param taskId
     * @return
     */
    @Deprecated
    String downloadTaskFile(String taskId);

    /**
     * 根据taskId下载文件
     *
     * @param taskId
     * @param key
     * @return
     */
    String downloadTaskFile(String taskId, String key);

    /**
     * 拒收
     *
     * @param logId
     * @param reason
     * @throws Exception
     */
    @Deprecated
    void refuseArchive(String logId, String reason) throws Exception;

    /**
     * 根据key拒收
     *
     * @param logId
     * @param reason
     * @param key
     * @throws Exception
     */
    void refuseArchive(String logId, String reason, String key) throws Exception;

    /**
     * 发送公文
     *
     * @param unitNos
     * @param receiverVo
     * @param nodeId
     * @param key
     * @return
     * @throws Exception
     */
    String uploadFile(String[] unitNos, ReceiverVo receiverVo, Integer nodeId, String key) throws Exception;

    /**
     * 获取组织机构集合，通过xml格式的文件返回
     *
     * @return
     * @throws Exception
     */
    @Deprecated
    String getAllGroupAndUnit() throws Exception;

    /**
     * 根据key获取组织机构集合，通过xml格式的文件返回
     *
     * @param key
     * @return
     * @throws Exception
     */
    String getAllGroupAndUnit(String key) throws Exception;

    /**
     * 根据条件查询收文记录总数
     *
     * @return
     */
    @Deprecated
    int getRecievedDataCount(Map params);

    /**
     * 根据key根据条件查询收文记录总数
     *
     * @param params 查询条件，
     * @param key
     * @return
     */
    int getRecievedDataCount(Map params, String key);

    /**
     * 根据条件查询收文列表信息
     *
     * @param params
     * @param pageIndex
     * @param pageSize
     * @return
     */
    @Deprecated
    public String getRecievedDataXml(Map params, int pageIndex, int pageSize);

    /**
     * 根据key根据条件查询收文列表信息
     *
     * @param params
     * @param pageIndex
     * @param pageSize
     * @return
     */
    String getRecievedDataXml(Map params, int pageIndex, int pageSize, String key);
}
