/*
 * Decompiled with CFR 0.152.
 */
package freemarker.sweet;

import freemarker.log.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils {
    private static final Pattern delimPattern = Pattern.compile("[\\[\\]\\.]");
    private static final Logger logger = Logger.getLogger((String)BeanUtils.class.getName());
    private static final Map<Class, Map<String, Field>> fieldCache = new ConcurrentHashMap<Class, Map<String, Field>>();

    public static <T> T getValue(Object obj, String name) {
        return BeanUtils.getValue(obj, BeanUtils.split(name));
    }

    private static String[] split(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = delimPattern.matcher(str);
        int index = 0;
        while (m.find()) {
            if (m.start() <= index) continue;
            String match = str.substring(index, m.start());
            tokens.add(match);
            index = m.end();
        }
        if (index < str.length() - 1) {
            tokens.add(str.substring(index));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static <T> T getValue(Object obj, String ... names) {
        if (names != null) {
            for (String name : names) {
                Object value = BeanUtils.getSimpleValue(obj, name);
                if (value == null) {
                    if (obj instanceof Map) {
                        value = ((Map)obj).get(name);
                    } else if (obj instanceof List) {
                        try {
                            value = ((List)obj).get(Integer.parseInt(name));
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                    }
                }
                if (value == null) {
                    return null;
                }
                obj = value;
            }
        }
        return (T)obj;
    }

    public static void setValue(Object obj, String name, Object value) {
        String[] tokens = BeanUtils.split(name);
        int lastIndex = tokens.length - 1;
        obj = BeanUtils.getValue(obj, Arrays.copyOf(tokens, lastIndex));
        BeanUtils.setSimpleValue(obj, tokens[lastIndex], value);
    }

    public static void setSimpleValue(Object obj, String name, Object value) {
        try {
            Field field = BeanUtils.getField(obj.getClass(), name);
            if (field != null) {
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            logger.error("set field  [" + name + "]  to value [" + value + "] error", (Throwable)e);
        }
    }

    public static <T> T getSimpleValue(Object obj, String name) {
        try {
            Field field = BeanUtils.getField(obj.getClass(), name);
            if (field != null) {
                return (T)field.get(obj);
            }
        }
        catch (Exception e) {
            logger.error("get field [" + name + "] value from [" + obj + "] error", (Throwable)e);
        }
        return null;
    }

    public static Field getField(Class clazz, String name) throws NoSuchFieldException {
        Field field;
        Map<String, Field> fieldMap = fieldCache.get(clazz);
        if (fieldMap == null) {
            fieldMap = new ConcurrentHashMap<String, Field>();
            fieldCache.put(clazz, fieldMap);
        }
        if ((field = fieldMap.get(name)) == null) {
            while (clazz != null) {
                try {
                    field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    fieldMap.put(name, field);
                    break;
                }
                catch (NoSuchFieldException ignored) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        return field;
    }
}

