/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.spring;

import com.gtis.config.AppConfig;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class Container {
    private static final Logger logger = LoggerFactory.getLogger(Container.class);
    private static BeanFactory factoryBean;

    public static void createApplicationContext(ServletContext ctx) {
        ContextLoader contextLoader = new ContextLoader();
        WebApplicationContext appContext = contextLoader.initWebApplicationContext(ctx);
        logger.info("Create webApplicationContext,use classpath path={}", (Object)ClassUtils.getDefaultClassLoader().getResource("/").toString());
        factoryBean = appContext;
        try {
            String platFormUrl = AppConfig.getPlatFormUrl();
            String fileCenterUrl = AppConfig.getFileCenterUrl();
            String casUrl = AppConfig.getCasUrl();
            ctx.setAttribute("platformurl", (Object)platFormUrl);
            ctx.setAttribute("filecenterurl", (Object)fileCenterUrl);
            ctx.setAttribute("casurl", (Object)casUrl);
        }
        catch (Exception e) {
            logger.error("spring context load error", (Throwable)e);
        }
    }

    public static Object getBean(String beanId) {
        if (factoryBean != null && factoryBean.containsBean(beanId)) {
            return factoryBean.getBean(beanId);
        }
        throw new NoSuchBeanDefinitionException(beanId, " not found!");
    }
}

