/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static final String ENCODING_DEFAULT = "UTF-8";
    private static final boolean NOCACHE_DEFAULT = true;
    private static final String CONTENT_TYPE = "text/json;charset=";

    public static String toString(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static void out(HttpServletResponse response, Object obj) {
        try {
            String encoding = ENCODING_DEFAULT;
            boolean noCache = true;
            response.setContentType(CONTENT_TYPE + encoding);
            if (noCache) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
            }
            response.getWriter().write(obj instanceof String ? (String)obj : JsonUtils.toString(obj));
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void out(Object obj) {
        HttpServletResponse response = ServletActionContext.getResponse();
        JsonUtils.out(response, obj);
    }
}

