/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.dform.excute.impl;

import com.gtis.dform.excute.FormExcute;
import com.gtis.dform.model.FormModelFactoryBean;
import com.gtis.dform.xml.FormXmlModel;
import com.gtis.dform.xml.FormXmlModelCollection;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormExecuteFactoryBean
implements FormExcute {
    private static final Log LOG = LogFactory.getLog(FormExecuteFactoryBean.class);
    FormModelFactoryBean formModelFactoryBean;
    FormXmlModelCollection formXmlModelCollection;
    Configuration freeMarkerConfigurer;

    public void setFormModelFactoryBean(FormModelFactoryBean formModelFactoryBean) {
        this.formModelFactoryBean = formModelFactoryBean;
    }

    public void setFormXmlModelCollection(FormXmlModelCollection formXmlModelCollection) {
        this.formXmlModelCollection = formXmlModelCollection;
    }

    public void setFreeMarkerConfigurer(Configuration freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    private String buildTemplate(String id, Map<String, Object> paramMap) {
        StringWriter sw = new StringWriter();
        try {
            Template t = this.freeMarkerConfigurer.getTemplate(id);
            t.process(paramMap, (Writer)sw);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sw.getBuffer().toString();
    }

    @Override
    @Transactional
    public Map<String, Object> executeCmds(String modelIds, Map<String, Object> paramMap) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String[] mIds = modelIds.split(",");
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        for (int i = 0; i < mIds.length; ++i) {
            String cmd;
            String mId = mIds[i].trim();
            FormXmlModel formXmlModel = this.formXmlModelCollection.getModel(mId);
            if (formXmlModel == null || !StringUtils.isNotBlank((String)(cmd = this.buildTemplate(formXmlModel.getId(), paramMap)))) continue;
            if (cmd.indexOf("$") > 0) {
                throw new Exception("------\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u8bbe\u7f6e\u6216\u6a21\u578b" + formXmlModel.getId() + "\uff01-----/n" + cmd);
            }
            Object result = this.formModelFactoryBean.executeCmd(formXmlModel.getName(), cmd);
            Map<String, Object> excuteMap = this.buildResult(formXmlModel, result);
            resultMap.putAll(excuteMap);
            paramMap.putAll(excuteMap);
        }
        return resultMap;
    }

    private Map<String, Object> buildResult(FormXmlModel formXmlModel, Object result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (result != null && StringUtils.isNotBlank((String)result.toString())) {
            if (StringUtils.isNotBlank((String)formXmlModel.getKey())) {
                resultMap.put(formXmlModel.getKey(), result);
            } else if (result instanceof Map) {
                resultMap.putAll((Map)result);
            } else {
                resultMap.put(formXmlModel.getId(), result);
            }
        }
        return resultMap;
    }
}

