package com.gtis.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class DatabaseDataFetcher implements DataFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseDataFetcher.class);
    protected JdbcTemplate jdbcTemplate;
    protected String sql;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean hasDataSource() {
        return jdbcTemplate != null;
    }

    @SuppressWarnings("unchecked")
    public Map<String, Serializable> fetchData(String id) {
        Map<String, Serializable> dataMap = new HashMap<String, Serializable>();
        Map<String, Serializable> map = null;
        try {
            map = jdbcTemplate.queryForMap(sql, getParams(id));
        } catch (DataAccessException e) {
            LOG.debug("Fetch date error:[{}]", e.getMessage());
        }
        if (map != null) {
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                dataMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        return dataMap;
    }

    public String getDescription() {
        return getClass() + " sql:[" + sql + "]";
    }

    protected Object[] getParams(String id) {
        return new Object[]{id};
    }
}
