package com.gtis.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-13
 */
public abstract class AbstractCategory {
    private String id;
    private String name;
    private String icon;
    protected Map<String, String> tpls = new HashMap<String, String>(4);
    protected Map<String, Serializable> tplVars = new HashMap<String, Serializable>(4);

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Map<String, String> getTpls() {
        return tpls;
    }

    public void setTpls(Map<String, String> tpls) {
        this.tpls = tpls;
    }

    public Map<String, Serializable> getTplVars() {
        return tplVars;
    }

    public void setTplVars(Map<String, Serializable> tplVars) {
        this.tplVars = tplVars;
    }

    public String getTpl(String name) {
        return tpls.get(name);
    }

    public void addTpl(String name, String tpl) {
        tpls.put(name, tpl);
    }

    public void addTplVar(String name, Serializable value) {
        tplVars.put(name, value);
    }

    @Override
    public String toString() {
        return "[" + id + "," + name + "]";
    }
}
