package com.gtis.plat.service;

import java.util.HashMap;
import java.util.List;

public interface SysStuffService {

    public List<HashMap<String, String>> getStuffConfig();

    public List<HashMap<String, String>> getStuffConfigByProId(String proId);

    public List<HashMap<String, String>> getFileByStuffId(String stuffId);

    public HashMap<String, String> getFileById(String fileId);

    public void deleteFileById(String stuffId);

    public boolean insertStuffFile(HashMap stuffFile);

    public boolean updateStuffFile(HashMap stuffFile);

    public HashMap<String, byte[]> getFileContentById(String fileId);

    public List<HashMap<String, String>> getFileByStuffIdProId(HashMap map);

    public boolean insertStuffConfig(HashMap stuffConfig);

    public void deleteConfigById(String stuffId);

    public void deleteConfigByProId(String proId);

    public List<String> getStuffIdByProId(String proId);

    public List<String> getFileIdByProId(String proId);

    public HashMap<String, String> getStuffConfigByStuffId(String stuffConfigId);

    /**
     * 根据WorkflowDefinitionId和StuffName获取StuffId
     *
     * @param map 参数Map需要Put，WorkflowDefinitionId和StuffName
     * @return
     */
    public String getStuffIdbyWorkflowDefinitionIdAndStuffName(String workflowDefinitionId, String stuffName);

    /**
     * 根据ProId和StuffId来获取StuffFile列表
     *
     * @param map 参数Map需要Put，ProId和StuffId
     * @return
     */
    public List<HashMap<String, String>> getStuffFileByProIdAndStuffId(String proid, String stuffId);
}
