package com.gtis.plat.service;

import com.gtis.plat.vo.PfSmsVo;

/**
 * @(#)SysMsgService.java 2010-4-6 1:10:12
 * Copy Right Information	: 南京国图
 * Project 					: 短信发送服务
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public interface SysSmsService {

    /**
     * 发送短信
     *
     * @param sender  发送人的签名
     * @param phone   电话号码
     * @param content 短消息的内容
     * @return 消息在系统中的编号
     * @throws Exception
     */
    String sendMsg(String sender, String receive, String phone, String content) throws Exception;

    /**
     * 消息状态查询
     *
     * @param msgNo 消息编号
     * @return 息发送的状态:0、表示尚未发送；1、表示已经发送；-1、表示发送失败
     * @throws Exception
     */
    int msgState(String msgNo) throws Exception;

    /**
     * 发送短信
     *
     * @param sms 短信对象
     * @return
     * @throws Exception
     */
    String sendMsg(PfSmsVo sms) throws Exception;

    /**
     * 插入短息日志
     *
     * @param sms
     */
    void insertSmsLog(PfSmsVo sms);
}
