package com.gtis.ibatis;

import com.gtis.common.util.ReflectUtil;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.statement.SelectStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * 用于计数的SQL数量生成器
 *
 * @author C4ISR
 */
public class OrderByStatementUtil {

    public static MappedStatement createOrderByStatement(
            MappedStatement selectStatement) {
        return new OrderByStatement((SelectStatement) selectStatement);
    }

    public static String getOrderByStatementId(String selectStatementId) {
        return "__" + selectStatementId + "orderby__";
    }
}

class OrderByStatement extends SelectStatement {

    public OrderByStatement(SelectStatement selectStatement) {
        super();
        setId(OrderByStatementUtil.getOrderByStatementId(selectStatement.getId()));
        setResultSetType(selectStatement.getResultSetType());
        setFetchSize(1);
        setParameterMap(selectStatement.getParameterMap());
        setParameterClass(selectStatement.getParameterClass());
        setSql(selectStatement.getSql());
        setResource(selectStatement.getResource());
        setSqlMapClient(selectStatement.getSqlMapClient());
        setTimeout(selectStatement.getTimeout());
        List executeListeners = (List) ReflectUtil.getFieldValue(
                selectStatement, "executeListeners", List.class);
        if (executeListeners != null) {
            for (Object listener : executeListeners) {
                addExecuteListener((ExecuteListener) listener);
            }
        }
        ResultMap resultMap = new AutoResultMap(
                ((ExtendedSqlMapClient) getSqlMapClient()).getDelegate(), false);
        resultMap.setId(getId() + "-AutoResultMap");
        resultMap.setResultClass(Long.class);
        resultMap.setResource(getResource());
        setResultMap(resultMap);

    }

    @Override
    protected void executeQueryWithCallback(StatementScope statementScope,
                                            Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler,
                                            int skipResults, int maxResults) throws SQLException {

        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());

        try {
            parameterObject = validateParameter(parameterObject);

            Sql sql = super.getSql();

            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);

            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);

            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);

            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);

            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            ///////////////////////
            sqlString = getSqlString(statementScope, parameterObject, sql);
            //////////////////////
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the SQL statement or the result map.");
            RowHandlerCallback callback = new RowHandlerCallback(resultMap, resultObject, rowHandler);
            sqlExecuteQuery(statementScope, conn, sqlString, parameters, skipResults, maxResults, callback);

            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                postProcessParameterObject(statementScope, parameterObject, parameters);
            }

            errorContext.reset();
            sql.cleanup(statementScope);
            notifyListeners();
        } catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), e);
        } catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e);
        }
    }


    /**
     * 获取修改后的用于进行统计查询的SQL语句
     *
     * @param stateScope
     * @param parameterObject
     * @param sql
     * @return
     */
    private String getSqlString(StatementScope stateScope, Object parameterObject,
                                Sql sql) {
        String sqlString = sql.getSql(stateScope, parameterObject);
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map) parameterObject;
            if (parameterMap.get("_orderfield_") != null) {
                String orderField = parameterMap.get("_orderfield_").toString();
                String orderDir = "";
                if (parameterMap.get("_orderfield_") != null)
                    orderDir = parameterMap.get("_orderfield_").toString();
                sqlString = sqlString.trim();
                sqlString = "select * from (" + sqlString + ") order by " + orderField + " " + orderDir;
            }
        }

        return sqlString;
    }

    private ResultMap getResultMap(StatementScope stateScope,
                                   Object parameterObject, Sql sql) {
        return getResultMap();
    }


}
