/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NestedRuntimeException.java
 *
 * LastModified: 2009-09-16 11:38:19
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.ex;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class NestedRuntimeException extends RuntimeException {

    private static final long serialVersionUID = 6090607206463381411L;
    private Throwable cause;

    public NestedRuntimeException() {
        super();
    }

    public NestedRuntimeException(Throwable nested) {
        this.cause = nested;
    }

    public NestedRuntimeException(String msg) {
        super(msg);
    }

    public NestedRuntimeException(String msg, Throwable ex) {
        super(msg);
        this.cause = ex;
    }

    public Throwable getCause() {
        return (this.cause == this ? null : this.cause);
    }

    public String getMessage() {
        String message = super.getMessage();
        Throwable cause = getCause();
        if (cause != null) {
            return message + "; nested exception is " + cause;
        }
        return message;
    }

    public void printStackTrace(PrintStream ps) {
        if (getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            ps.print("Caused by: ");
            getCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            pw.print("Caused by: ");
            getCause().printStackTrace(pw);
        }
    }

    public Throwable getRootCause() {
        Throwable cause = getCause();
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException) cause).getRootCause();
        } else {
            return cause;
        }
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        if (exClass.isInstance(this)) {
            return true;
        }
        Throwable cause = getCause();
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException) cause).contains(exClass);
        } else {
            return (cause != null && exClass.isInstance(cause));
        }
    }
}
