package com.gtis.dform.excute.impl;

import com.gtis.dform.excute.FormExcute;
import com.gtis.dform.model.FormModelFactoryBean;
import com.gtis.dform.xml.FormXmlModel;
import com.gtis.dform.xml.FormXmlModelCollection;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 11-9-5
 * Time: 下午7:50
 * To change this template use File | Settings | File Templates.
 */
public class FormExecuteFactoryBean implements FormExcute {
    private static final Log LOG = LogFactory.getLog(FormExecuteFactoryBean.class);
    FormModelFactoryBean formModelFactoryBean;
    FormXmlModelCollection formXmlModelCollection;
    Configuration freeMarkerConfigurer;

    public void setFormModelFactoryBean(FormModelFactoryBean formModelFactoryBean) {
        this.formModelFactoryBean = formModelFactoryBean;
    }

    public void setFormXmlModelCollection(FormXmlModelCollection formXmlModelCollection) {
        this.formXmlModelCollection = formXmlModelCollection;
    }

    public void setFreeMarkerConfigurer(Configuration freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    private String buildTemplate(String id, Map<String, Object> paramMap) {
        StringWriter sw = new StringWriter();
        try {
            Template t = freeMarkerConfigurer.getTemplate(id);
            t.process(paramMap, sw);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return sw.getBuffer().toString();
    }

    @Transactional
    public Map<String, Object> executeCmds(String modelIds, Map<String, Object> paramMap) throws Exception {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String[] mIds = modelIds.split(",");
        if (paramMap == null) paramMap = new HashMap<String, Object>();
        for (int i = 0; i < mIds.length; i++) {
            String mId = mIds[i].trim();
            FormXmlModel formXmlModel = formXmlModelCollection.getModel(mId);
            if (formXmlModel != null) {
                String cmd = this.buildTemplate(formXmlModel.getId(), paramMap);
                if (StringUtils.isNotBlank(cmd)) {
                    if (cmd.indexOf("$") > 0) {
                        throw new Exception("------请检查传入参数设置或模型" + formXmlModel.getId() + "！-----/n" + cmd);
                    } else {
                        Object result = formModelFactoryBean.executeCmd(formXmlModel.getName(), cmd);
                        Map<String, Object> excuteMap = buildResult(formXmlModel, result);
                        resultMap.putAll(excuteMap);
                        paramMap.putAll(excuteMap);
                    }
                }
            }
        }
        return resultMap;
    }

    private Map<String, Object> buildResult(FormXmlModel formXmlModel, Object result) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (result != null && StringUtils.isNotBlank(result.toString())) {
            if (StringUtils.isNotBlank(formXmlModel.getKey())) {
                resultMap.put(formXmlModel.getKey(), result);
            } else if (result instanceof Map) {
                resultMap.putAll((Map) result);
            } else {
                resultMap.put(formXmlModel.getId(), result);
            }
        }
        return resultMap;
    }
}
