/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.sp.SmsSender;
import com.gtis.sp.impl.SmsSenderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.util.CollectionUtils;

public class HttpSmsSenderImpl
implements SmsSender {
    private HttpClient httpClient;
    private String spUrl;

    public void setSpUrl(String spUrl) {
        this.spUrl = spUrl;
    }

    public HttpSmsSenderImpl() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(10000);
        connectionManager.getParams().setSoTimeout(10000);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    @Override
    public void send(Date sendAt, String body, Collection<String> mobiles) throws SmsSenderException {
        if (StringUtils.isBlank((String)body) || CollectionUtils.isEmpty(mobiles)) {
            return;
        }
        PostMethod filePost = new PostMethod(this.spUrl);
        filePost.addParameter("text", body.trim());
        if (sendAt != null) {
            filePost.addParameter("sendAt", DateFormatUtils.ISO_DATETIME_FORMAT.format(sendAt));
        }
        filePost.addParameter("mobile", StringUtils.join(mobiles, (String)","));
        try {
            this.httpClient.executeMethod((HttpMethod)filePost);
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)filePost.getResponseBodyAsStream(), (Writer)sw, (String)"UTF-8");
            JSONObject json = JSON.parseObject((String)sw.toString());
            if (!json.getBooleanValue("ret")) {
                throw new SmsSenderException(json.getString("msg"));
            }
        }
        catch (IOException e) {
            throw new SmsSenderException("Sms send fail", e);
        }
    }
}

