package com.gtis.plat.vo;

import com.gtis.common.util.CommonUtil;

import java.util.Date;

/**
 * @author wlw 异常
 */
public class EcExceptionVo implements java.io.Serializable {

    public static final int ACTITIME_EXCECODE = 1;// 岗位时限异常
    public static final int WFTIME_EXCECODE = 2;// 事项办理异常
    public static final int BACKTIMES_EXCECODE = 3;// 流程退回异常
    public static final int DECIDE_EXCECODE = 4;// 办件决定异常
    public static final int FEE_EXCECODE = 5;// 办件收费异常
    public static final int HOLD_EXCECODE = 6;// 流程挂起异常
    public static final int COMPLAINTS_EXCECODE = 7;// 用户投诉异常
    public static final int ATTENDAMCE_EXCECODE = 8;// 工作人员考勤异常
    private static final long serialVersionUID = -1882258471245370126L;

    private String exceptionId;

    private int exceptionType = 0;

    private Date exceptionRecTime;

    private String workflowInstanceId;

    private String activityId;

    private String userId;

    private String organId;

    private String descXML;

    private String checkUserId;

    private int isSure;

    private Date checkTime;

    private String checkInfo;

    //初始化 岗位时限异常方法
    public void actitime_exception(String exceptionId,
                                   String workflowInstanceId, String activityId, String userId,
                                   String organId, String checkUserId, int isSure, Date checkTime,
                                   String checkInfo, String userName, String activityName,
                                   int timeLimit, int handlesDay, Date beginTime) {
        this.exceptionId = exceptionId;
        this.exceptionType = ACTITIME_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc activity_name=\"" + activityName
                + "\" time_limit=\"" + timeLimit + "\" handles_day=\""
                + handlesDay + "\" begin_time=\"" + CommonUtil.formateDate(beginTime)
                + "\" out_time=\"" + (handlesDay - timeLimit) + "\"/>");
//		builder.append("</xml>");
        this.descXML = builder.toString();

    }

    //初始化 事项办理异常
    public void wftime_exception(String exceptionId, String workflowInstanceId,
                                 String checkUserId, int isSure, Date checkTime, String checkInfo,
                                 int timeLimit, int handlesDay, Date beginTime) {
        this.exceptionId = exceptionId;
        this.exceptionType = WFTIME_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc time_limit=\"" + timeLimit + "\" handles_day=\""
                + handlesDay + "\" begin_time=\"" + CommonUtil.formateDate(beginTime)
                + "\" out_time=\"" + (handlesDay - timeLimit) + "\"/>");
//		builder.append("</xml>");
        this.descXML = builder.toString();

    }

    // 初始化 流程退回异常
    public void backtimes_exception(String exceptionId,
                                    String workflowInstanceId, String activityId, String userId,
                                    String organId, String checkUserId, int isSure, Date checkTime,
                                    String checkInfo, int backTimes) {
        this.exceptionId = exceptionId;
        this.exceptionType = BACKTIMES_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc backtimes =\"" + backTimes + "\"/>");
//		builder.append("</xml>");
        this.descXML = builder.toString();
    }

    //初始化 办件决定异常
    public void decide_exception(String exceptionId, String workflowInstanceId,
                                 String activityId, String userId, String organId,
                                 String checkUserId, int isSure, Date checkTime, String checkInfo) {
        this.exceptionId = exceptionId;
        this.exceptionType = DECIDE_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc/>");
//		builder.append("</xml>");
        this.descXML = builder.toString();
    }

    //初始化 办件收费异常
    public void fee_exception(String exceptionId, String workflowInstanceId,
                              String activityId, String userId, String organId,
                              String checkUserId, int isSure, Date checkTime, String checkInfo,
                              float needFee, float getFee) {
        this.exceptionId = exceptionId;
        this.exceptionType = FEE_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc needfee=\"" + needFee + "\" getfree=\"" + getFee
                + "\"/>");
//		builder.append("</xml>");
        this.descXML = builder.toString();
    }

    //初始化 流程挂起异常
    public void hold_exception(String exceptionId, String workflowInstanceId,
                               String activityId, String userId, String organId,
                               String checkUserId, int isSure, Date checkTime, String checkInfo) {
        this.exceptionId = exceptionId;
        this.exceptionType = HOLD_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc />");
//		builder.append("</xml>");
        this.descXML = builder.toString();
    }

    // 初始化 用户投诉异常
    public void complaints_exception(String exceptionId,
                                     String workflowInstanceId, String activityId, String userId,
                                     String organId, String checkUserId, int isSure, Date checkTime,
                                     String checkInfo, String complainId) {
        this.exceptionId = exceptionId;
        this.exceptionType = COMPLAINTS_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc 投诉ID=\"" + complainId + "\"/>");
//		builder.append("</xml>");
        this.descXML = builder.toString();
    }

    // 初始化 工作人员考勤异常
    public void attendamce_exception(String exceptionId, String checkUserId,
                                     int isSure, Date checkTime, String checkInfo) {
        this.exceptionId = exceptionId;
        this.exceptionType = ATTENDAMCE_EXCECODE;
        this.exceptionRecTime = new Date(System.currentTimeMillis());
        this.workflowInstanceId = workflowInstanceId;
        this.activityId = activityId;
        this.userId = userId;
        this.organId = organId;
        this.checkUserId = checkUserId;
        this.isSure = isSure;
        this.checkTime = checkTime;
        this.checkInfo = checkInfo;
        StringBuilder builder = new StringBuilder(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<desc />");
//		builder.append("</xml>");
        this.descXML = builder.toString();
    }

    public String getExceptionId() {
        return exceptionId;
    }

    public void setExceptionId(String exceptionId) {
        this.exceptionId = exceptionId;
    }

    public int getExceptionType() {
        return exceptionType;
    }

    public void setExceptionType(int exceptionType) {
        this.exceptionType = exceptionType;
    }

    public Date getExceptionRecTime() {
        return exceptionRecTime;
    }

    public void setExceptionRecTime(Date exceptionRecTime) {
        this.exceptionRecTime = exceptionRecTime;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOrganId() {
        return organId;
    }

    public void setOrganId(String organId) {
        this.organId = organId;
    }

    public String getDescXML() {
        return descXML;
    }

    public void setDescXML(String descXML) {
        this.descXML = descXML;
    }

    public String getWorkflowInstanceId() {
        return workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getCheckUserId() {
        return checkUserId;
    }

    public void setCheckUserId(String checkUserId) {
        this.checkUserId = checkUserId;
    }

    public int getIsSure() {
        return isSure;
    }

    public void setIsSure(int isSure) {
        this.isSure = isSure;
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getCheckInfo() {
        return checkInfo;
    }

    public void setCheckInfo(String checkInfo) {
        this.checkInfo = checkInfo;
    }

}
