package com.gtis.plat.service;

import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.PerformerModel;

import java.util.List;

public interface SysUserService {

    public List<PfUserVo> getUserVoListByUserName(String userName);

    public List<PfUserVo> getUserVoListByUserNameFuzzy(String userName);

    public List<PfOrganVo> getOrganListByUser(String userId);

    public List<PfRoleVo> getRoleListByUser(String userId);

    public PfUserVo getUserByloginName(String loginName);

    public List<String> getRoleListByAgentUser(String userId);

    public List<PfUserVo> getUserListByOragn(String oragnId);

    public List<PfUserVo> getUserListByRole(String roleId);

    public PfUserVo getUserVo(String userId);

    public PfRoleVo getRoleVo(String roleId);

    public PfOrganVo getOrganVo(String organId);

    public PfOrganVo getOrganVoByName(String organName);

    public List<String> getAllUserListPerformers(
            List<PerformerModel> lstPerformers);

    public List<String> getUserListPerformersByUserOrgan(
            List<PerformerModel> lstPerformers, String userId);

    public boolean savePassWord(String userId, String loginPassWord);

    public void saveConfig(PfConfigVo vo);

    public PfConfigVo getConfigVo(String userId);

    public String getUserRegionCode(String userId);

    public List<PfOrganVo> getOrganListByRemark(String remark);

    /**
     * 查询一个部门和角色下的人员
     *
     * @param roleId
     * @param organId
     * @return
     */
    public List<PfUserVo> getUserListByRoleAndOrgan(String roleId, String organId);

    /**
     * 查询多个部门和角色下的人员
     *
     * @param roleId
     * @param organList
     * @return
     */
    public List<PfUserVo> getUserListByRoleAndOrganIds(String roleId, List<String> organList);

    /**
     * 根据用户Id获得地狱码
     *
     * @param userId
     * @return
     */
    public String getRegionCodeByUserId(String userId);

    /**
     * 根据地域码获得部门列表
     *
     * @param regionCode
     * @return
     */
    public List<PfOrganVo> getOrganByRegionCode(String regionCode);

    /**
     * 获取部门列表
     *
     * @return
     */
    public List<PfOrganVo> getOrganList();

    /**
     * 获取角色列表
     *
     * @return
     */
    public List<PfRoleVo> getRoleList();

    /**
     * 获得所有用户
     *
     * @return
     */
    public List<PfUserVo> getAllUsers();

    /**
     * 根据部门名查找用户
     *
     * @return
     */
    public List<PfUserVo> getUsersByOrganName(String orginName);

    /**
     * 更新用户信息
     *
     * @param userVo
     */
    void updateUser(PfUserVo userVo);

    /**
     * 获取所有部门
     *
     * @return
     */
    public List<PfOrganVo> getAllOrganList();

    /**
     * 获取有效用户代理人列表
     *
     * @param userId
     * @return
     */
    public String getUserAgentList(String userId);

    /**
     * 获得有效任务代理信息列表
     *
     * @param userId
     * @return
     */
    public List<PfTaskAgentVo> getAgentUserList(String userId);

    /**
     * 增加任务代理
     *
     * @param pfTaskAgentVo
     */
    public void insertTaskAgent(PfTaskAgentVo pfTaskAgentVo);

    /**
     * 删除任务代理
     *
     * @param taskAgentId
     */
    public void deleteTaskAgent(String taskAgentId);

    /**
     * 根据角色的名称获取角色列表模糊
     *
     * @param roleName
     * @return
     */
    public List<PfRoleVo> getRoleVoListByRoleNameFuzzy(String roleName);

    /**
     * 根据regionde获取部门列表
     *
     * @param regionCode
     * @return
     */
    public List<PfOrganVo> getOrganListByRegionCode(String regionCode);
}
