package com.gtis.ibatis;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OracleObjectTypeHandler extends BaseTypeHandler implements
        TypeHandler {

    public static final SimpleDateFormat timeFormat = new SimpleDateFormat(
            "yyyy-MM-dd HH:mm:ss");

    /**
     * @see TypeHandler#setParameter(PreparedStatement, int, Object, String)
     */
    public void setParameter(PreparedStatement ps, int i, Object parameter,
                             String jdbcType) throws SQLException {
        ps.setObject(i, parameter);
    }

    public Object convertFromString(String value) {
        Date date = null;
        try {
            date = timeFormat.parse(value);
        } catch (Exception e) {

        }
        return date;
    }

    /**
     * @see TypeHandler#getResult(ResultSet, String)
     */
    public Object getResult(ResultSet rs, String columnName)
            throws SQLException {
        Object object = rs.getObject(columnName);
        if (object instanceof java.sql.Date) {
            Object dateConvert = convertFromString(rs.getString(columnName));
            if (dateConvert != null)
                object = dateConvert;
        }
        if (rs.wasNull()) {
            return null;
        } else {
            return object;
        }
    }

    /**
     * @see TypeHandler#getResult(ResultSet, int)
     */
    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        Object object = rs.getObject(columnIndex);
        if (object instanceof java.sql.Date) {
            Object dateConvert = convertFromString(rs.getString(columnIndex));
            if (dateConvert != null)
                object = dateConvert;
        }
        if (rs.wasNull()) {
            return null;
        } else {
            return object;
        }
    }

    /**
     * @see TypeHandler#getResult(CallableStatement, int)
     */
    public Object getResult(CallableStatement cs, int columnIndex)
            throws SQLException {
        Object object = cs.getObject(columnIndex);
        if (object instanceof java.sql.Date) {
            Object dateConvert = convertFromString(cs.getString(columnIndex));
            if (dateConvert != null)
                object = dateConvert;
        }
        if (cs.wasNull()) {
            return null;
        } else {
            return object;
        }
    }

    /**
     * @see TypeHandler#valueOf(String)
     */
    public Object valueOf(String s) {
        return s;
    }

    // /**
    // * !@#@%$%^$%%!@#%$%^#$%#!%#$^$#%^
    // *
    // * @param obj
    // * 　object from oracle jdbc driver
    // * @return object of suitable java datatype
    // */
    // protected Object fix(Object obj) {
    // try {
    //
    // if (obj instanceof TIMESTAMP) {
    // return new Date(((TIMESTAMP) obj).dateValue().getTime());
    // } else if (obj instanceof DATE) {
    // return new Date(((DATE) obj).dateValue().getTime());
    // } else if (obj instanceof TIMESTAMPLTZ) {
    // return new Date(((TIMESTAMPLTZ) obj).dateValue().getTime());
    // } else if (obj instanceof TIMESTAMPTZ) {
    // return new Date(((TIMESTAMPTZ) obj).dateValue().getTime());
    // } else if (obj instanceof java.sql.Date) {
    // return new Date(((TIMESTAMPTZ) obj).dateValue().getTime());
    // } else {
    // return obj;
    // }
    // } catch (Exception e) {
    // return obj;
    // }
    // }

}
