/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NodeExistsException.java
 *
 * LastModified: 2009-09-22 01:22:19
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.ex;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class NodeExistsException extends NestedRuntimeException {

    private static final long serialVersionUID = 3203859625104060811L;
    private Integer parentId;

    private String name;

    public NodeExistsException(Integer parentId, String name) {
        super("node name " + name + " under parentId " + parentId + " has been existed");
        this.parentId = parentId;
        this.name = name;
    }

    public NodeExistsException(String msg) {
        super(msg);
    }

    public Integer getParentId() {
        return parentId;
    }

    public String getName() {
        return name;
    }
}
