package com.gtis.dform.model;

import org.springframework.beans.factory.InitializingBean;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * User: jibo
 * Date: 11-9-5
 * Time: 下午4:55
 * To change this template use File | Settings | File Templates.
 */
public class FormModelFactoryBean implements InitializingBean {
    private List<FormModel> models;
    private Map<String, FormModel> modelMap;

    public List<FormModel> getModels() {
        return models;
    }

    public void setModels(List<FormModel> models) {
        this.models = models;
    }


    public void afterPropertiesSet() throws Exception {
        modelMap = new HashMap<String, FormModel>();
        if (this.models != null) {
            for (FormModel model : models) {
                modelMap.put(model.getName(), model);
            }
        }
    }

    /**
     * 执行一个命令,根据node的nodename
     *
     * @param nodeName
     * @param cmd
     * @return
     */
    public Object executeCmd(String nodeName, String cmd) {
        FormModel formModel = modelMap.get(nodeName);
        if (formModel != null) {
            return formModel.executeCmd(cmd);
        } else {
            return null;
        }
    }
}
