package com.gtis.cas;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.CookieRetrievingCookieGenerator;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-12-7
 */
public class SimpleLoginController extends AbstractController {

    private CentralAuthenticationService centralAuthenticationService;

    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;

    private String redirecUrl;

    public void setRedirecUrl(String redirecUrl) {
        this.redirecUrl = redirecUrl;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setTicketGrantingTicketCookieGenerator(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("username");
        String password = request.getParameter("password");
        String url = request.getParameter("url");
        if (name != null && !"".equals(name)) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials();
            credentials.setUsername(name);
            credentials.setPassword(password == null ? "" : password);
            String ticketId = null;
            try {
                ticketId = centralAuthenticationService.createTicketGrantingTicket(credentials);
            } catch (TicketException e) {
                response.setContentType("text/json; charset=utf-8");
                response.getWriter().write("{result:false,error:'" + e.getMessage() + "'}");
                return null;
            }
            ticketGrantingTicketCookieGenerator.addCookie(request, response, ticketId);
        }
        if(url!=null && !"".equals(url)){
            response.sendRedirect(url);
        }
        if (redirecUrl != null) {
            response.sendRedirect(redirecUrl);
        } else {
            response.getWriter().write("{result:true}");
        }
        return null;
    }
}
