package com.gtis.cas;

import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collection;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-2-26
 */
public class OnlineController extends AbstractController {

    private final TicketRegistry ticketRegistry;

    public OnlineController(final TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuilder sb = new StringBuilder();
        try {
            final Collection<Ticket> tickets = this.ticketRegistry.getTickets();
            for (Ticket ticket : tickets) {
                if (!ticket.isExpired() && ticket instanceof TicketGrantingTicket)
                    sb.append(((TicketGrantingTicket) ticket).getAuthentication().getPrincipal().getId()).append(",").append(ticket.getCreationTime()).append("|");
            }
        } catch (final UnsupportedOperationException ignored) {
        }
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().print(sb);
        return null;
    }
}
