package com.gtis.cas;

import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;

import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-7-16
 */
public final class EgovDynamicRedirectViewSelector implements ViewSelector {

    private String platformUrl;

    public void setPlatformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
    }

    public ViewSelection makeRefreshSelection(final RequestContext context) {
        return makeEntrySelection(context);
    }

    public boolean isEntrySelectionRenderable(final RequestContext request) {
        return false;
    }

    public ViewSelection makeEntrySelection(final RequestContext request) {
        final WebApplicationService service = WebUtils.getService(request);
        final String ticket = WebUtils.getServiceTicketFromRequestScope(request);
        final Response serviceResponse = service.getResponse(ticket);

        switch (serviceResponse.getResponseType()) {
            case POST:
                final Map<String, Object> model = new HashMap<String, Object>();
                model.put("parameters", serviceResponse.getAttributes());
                model.put("originalUrl", service.getId());
                return new ApplicationView("postResponseView", model);
            default:
                return new ExternalRedirect(platformUrl != null && request.getExternalContext().getRequestParameterMap().get("username") != null ?
                        platformUrl + "?ticket=" + ticket :
                        serviceResponse.getUrl());
        }
    }
}
