package com.gtis.archive.web;

import com.gtis.archive.service.VRService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * .VrAction
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/26 13:15
 */
public class VrAction implements Action {

    @Autowired
    private VRService vrService;

    private String roomId;

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    public List getRooms(){
        return vrService.getRoomsOnly();
    }

    public Map getRoom(){
        return vrService.getRoomById(roomId);
    }

    public List getRoomCabinets(){
        try {
            return (List) vrService.getRoomById(roomId).get(VRService.Tag.cabinets.name());
        } catch (Exception e) {
            return new ArrayList();
        }
    }

    /**
     * get room details
     *
     */
    public void roomDetail(){
        Struts2Utils.renderJson(getRoom());
    }

    /**
     * open room
     *
     * @return
     */
    public String room(){
        return "room";
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }
}
