package com.gtis.archive.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.service.VRService;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/29 13:45
 */
public class VRServiceImpl implements VRService {

    private static final Logger logger = LoggerFactory.getLogger(VRServiceImpl.class);

    private Resource location;

    /**
     * get vr config
     *
     * @return
     */
    @Override
    public Map getConfig() {
        try {
            return JSON.parseObject(IOUtils.toByteArray(location.getURI()), Map.class);
        } catch (Exception e) {
            logger.error("read vr config.cfg error [{}]", e.getLocalizedMessage());
            throw new VRException(e.getLocalizedMessage());
        }
    }

    /**
     * get vr rooms
     *
     * @return
     */
    @Override
    public List getRooms() {
        return (List) getConfig().get(Tag.rooms.name());
    }

    /**
     * get rooms only
     *
     * @return
     */
    @Override
    public List getRoomsOnly() {
        List<Map> rooms = getRooms();
        for (Map room : rooms) {
            if (room.containsKey(Tag.cabinets.name())) room.remove(room.get(Tag.cabinets.name()));
        }
        return rooms;
    }

    /**
     * get room by id
     *
     * @param roomId
     * @return
     */
    @Override
    public Map getRoomById(String roomId) {
        List<Map> rooms = getRooms();
        for (Map room : rooms) {
            if (room.get(Tag.id.name()).equals(roomId)) return room;
        }
        throw new RuntimeException(" room " + roomId + " not found");
    }

    public void setLocation(Resource location) {
        this.location = location;
    }
}
