package com.gtis.archive.service.impl;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.archive.service.OriginalService;
import com.gtis.common.Page;
import com.gtis.generic.util.ImageUtils;
import com.gtis.plat.vo.UserInfo;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;

import java.awt.datatransfer.FlavorEvent;
import java.net.URLEncoder;
import java.util.*;
import java.io.*;

import com.gtis.archive.core.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-30
 */
public class OriginalServiceImpl extends HibernateTemplate<Original, String> implements OriginalService {
    public static final String THUMB_PREFIX = "__thumb.jpg";
    public static final long MAX_SIZE = 1024 * 1024 * 5;
    public static final long TASK_SIZE = 1024 * 1024;
    public static final int MICRO_IMAGE_WIDTH = 96;
    public static final int MICRO_IMAGE_HEIGHT = 96;

    public  static boolean flag = false ;

    public  static  String filePath = "" ;

    public  static  int fileSize = -1 ;

    private final static Logger logger = LoggerFactory.getLogger(OriginalServiceImpl.class);
    private String previewServerUrl;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private OriginalPermissionService originalPermissionService;
    @Autowired
    private TaskExecutor taskExecutor;

    @Autowired
    protected EntityService entityService;

    public void setPreviewServerUrl(String previewServerUrl) {
        this.previewServerUrl = previewServerUrl;
    }

    public Original getOriginal(String id) {
        return get(id);
    }

    public static String getThumbPrefix() {
        return THUMB_PREFIX;
    }

    public static int getFileSize() {
        return fileSize;
    }

    public static void setFileSize(int fileSize) {
        OriginalServiceImpl.fileSize = fileSize;
    }

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String filePath) {
        OriginalServiceImpl.filePath = filePath;
    }

    /**
     * 获取变量
     * @param evn
     * @return
     */
    private Collection getSet(Environment evn){
        Collection set=null;
        if(evn.getProps().size()==0){
            set=getSet(evn.getParent());
        } else{
            set= evn.getProps().keySet();
        }
        return set;
    }


    @Transactional
    public void removeOriginal(String[] ids) {
        for (String id : ids) {
            Original original = getOriginal(id);
            if (Constants.ORIGINAL_POWER.equals(original.getStatus())) {
                logger.info("该原文处于只读状态，无法编辑,[original_id=" + original.getId() + ";original_name="
                        + original.getName() + "]");
            } else {
                if (original != null) {
                    if (!original.getPath().startsWith("${myOriginalPath}")) { //关联的文件不删除
                        String path = EnvHolder.getAppEnv().getExpr(original.getPath());
                        File file = getFile(path);
                        if (file != null && file.exists() && !file.delete()) {
                            logger.info("delete file [" + file.getAbsolutePath() + "] error");
                        }
                        file = getFile(path + THUMB_PREFIX);
                        if (file != null && file.exists() && !file.delete()) {
                            logger.info("delete file [" + file.getAbsolutePath() + "] error");
                        }
                    }
                }
                delete(id);
                if (originalPermissionService.isOriginalPermissionEnable()) {
                    batchExecute("delete from DownloadLog d where d.originalId=?", id);
                    batchExecute("delete from OriginalPermission d where d.originalId=?", id);
                }
            }
        }
    }


    @Transactional
    public void saveOriginal(Original original) {
        original.setUpdateTime(new Date());
        save(original);
        if (originalPermissionService.isOriginalPermissionEnable()) {
            UserInfo user = SessionUtil.getCurrentUser();
            if (user != null && !user.isAdmin()) {
                OriginalPermission op = new OriginalPermission();
                op.setUserId(user.getId());
                op.setUserName(user.getUsername());
                op.setOperation("download");
                op.setOriginalId(original.getId());
                originalPermissionService.saveOriginalPermission(op);
            }
        }
        if (!original.canMakeThumb())
            return;
        String path = EnvHolder.getAppEnv().getExpr(original.getPath()) + THUMB_PREFIX;
        File file = getFile(path);
        if ((file == null || !file.exists()) && original.getFileSize() > TASK_SIZE) {
            createThumbFile(original);
        }
    }

    @Transactional
    public List<Original> getOriginals(String ownerId) {
        List<Original> list = syncOriginals(ownerId);
        if (list == null) {
            list = getDbOriginals(ownerId);
        }
        return list;
    }

    private List<Original> syncOriginals(String ownerId) {
        if (EnvHolder.isEnable(Switch.AUTO_IDENTIFY_ORIGINAL)) {
            List<Original> list = getDbOriginals(ownerId);
            Map<String, Original> fsOgs = getFsOriginals(ownerId);
            if (fsOgs.size() != list.size()) {
                for (Original og : list) {
                    if (fsOgs.containsKey(og.getName())) {
                        fsOgs.remove(og.getName());
                    } else {
                        //delete(og.getId()); //删除不存在的文件,暂时不处理
                    }
                }
                if (!fsOgs.isEmpty()) {
                    for (Original og : fsOgs.values()) {
                        og.setUpdateTime(new Date());
                        logger.info("syncOriginal"+System.currentTimeMillis());
                        save(og);
                    }
                    return null;
                }
            }
            return list;
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    private List<Original> getDbOriginals(String ownerId) {
        return createCriteria(Restrictions.eq("ownerId", ownerId)).addOrder(Order.asc("name")).list();
    }

    List<String> getOriginalPath(Model model){
        Collection set =getSet(model.getEnv().getParent());
        List<String> path = new ArrayList<String>();
        List<String> al = new ArrayList<String>();
        al.addAll(set);
        for(Iterator iter =al.iterator();iter.hasNext();){
            String s = (String) iter.next();
            if(s.contains("originalRoot_")){
                path.add(s) ;
            }
        }
        return path ;
    }

    private Map<String, Original> getFsOriginals(String ownerId) {
        Object owner = getOriginalOwner(ownerId);
        if (owner == null)
            owner = getOwner(ownerId);
        Model model = modelService.getModel(owner);
        String relativePath = getRelativePath(owner, model);
        File storePath = null;
        Map<String, Original> map = new HashMap<String, Original>();

        for(String pathName : getOriginalPath(model)){
            storePath = getFile(model.getEnv().get(pathName) + "/" + relativePath);
            if (storePath.exists()) {
                File[] fs = storePath.listFiles();
                if (fs != null) {
                    for (File file : fs) {
                        if (file.isDirectory())
                            continue;
                        String name = file.getName();
                        if (name.endsWith(THUMB_PREFIX) || "thumb.db".equals(name))
                            continue;
                        Original og = new Original();
                        og.setOwnerId(ownerId);
                        og.setName(file.getName());
                        og.setFileSize(file.length());
//                      og.setPath("${originalRoot}/" + relativePath + "/" + og.getName());
                        og.setPath("${"+ pathName+ "}/" + relativePath + "/" + og.getName());
                        og.setOwnerModelName(model.getName());
                        map.put(file.getName(), og);
                    }
                }
            }
        }

        return map;
    }

    public Object getOriginalOwner(String id) {
        Archive archive = archiveService.getSimpleArchive(id);
        return archive != null ? archive : archiveService.getSimpleDocument(id);
    }

    /**
     *
     * @param modelName
     * @param id
     * @return
     */
    public Object getOriginalOwner(String modelName, String id){
        if(modelName.contains("_jn")){
            return  archiveService.getDocument(modelName,id);
        }else {
            return archiveService.getArchive(modelName,id);
        }
    }

    public Object getOwner(String ownerId) {
        Object entity = entityService.load("ythsw", ownerId);
        if (entity == null)
            entity = entityService.load("ythfw", ownerId);
        if (entity == null)
            entity = entityService.load("ythnw", ownerId);
        return entity;
    }

    @Transactional
    public File getOriginalFile(String id, String action) {
        Original original = getOriginal(id);
        String path = EnvHolder.getAppEnv().getExpr(original.getPath());
        if (originalPermissionService.isOriginalPermissionEnable()) {
            saveDownloadLog(original, action);
        }
        return getFile(path);
    }

    public File getOriginalThumbFile(String id) {
        Original original = getOriginal(id);
        String path = EnvHolder.getAppEnv().getExpr(original.getPath()) + THUMB_PREFIX;
        File file = getFile(path);
        if ((file == null || !file.exists()) && original.isImage() && original.getFileSize() < TASK_SIZE) {
            createThumbFile(original);
        }
        return getFile(path);
    }

    public void saveOriginalFile(Original original, File file, boolean overWrite) {
        Object owner = getOriginalOwner(original.getOwnerId());
        if (owner == null)
            owner = getEntity(original);
        if (owner == null) {
            throw new IllegalStateException("Owner for original [" + original + "] is null");
        }
        Model model = modelService.getModel(owner);
        String relativePath = getRelativePath(owner, model);
        Collection set = model.getEnv().getParent().getProps().keySet();
        List<String> al = new ArrayList<String>();

        al.addAll(set);
        for (Iterator i = al.iterator(); i.hasNext(); ) {
            String s = (String) i.next();
            if (!s.contains("originalRoot")) {
//            if(!s.startsWith("originalRoot_")){
                i.remove();
            }
        }
        File path = null;
        for (int i = 0; i < al.size(); i++) {
            path = getFile(model.getEnv().get(al.get(i)) + "/" + relativePath);
            if ((path.getUsableSpace()) >= (original.getFileSize())) {

                if (file != null && !path.exists())
                    if (!path.mkdirs())
                        throw new RuntimeException("mkdir [" + relativePath + "] error");
                String fileName = original.getName();
                File f = getFile(path + "/" + fileName);
                try {
                    if (f != null && f.exists() && !overWrite) {
                        String rename = rename(f, original.getName());
                        f = getFile(path + "/" + rename);
                        original.setName(rename);
                    }
                    FileCopyUtils.copy(file, f);
                    original.setPath("${" + al.get(i) + "}/" + relativePath + "/" + original.getName());
                    original.setOwnerModelName(model.getName());
                    if (f != null)
                        original.setFileSize(f.length());
                    break;
                } catch (IOException ignored) {
                }
            } else {
                continue;
            }

        }


    }

    @Override
    public void saveOriginalFile(Original original, File file, String ownerModelName, boolean overWrite) {
        Object owner = getOriginalOwner(ownerModelName,original.getOwnerId());
        Model model = modelService.getModel(owner).getParent();
        String relativePath = getRelativePath(owner, model);
        Collection set = model.getEnv().getParent().getProps().keySet();
        List<String> al = new ArrayList<String>();

        al.addAll(set);
        for (Iterator i = al.iterator(); i.hasNext(); ) {
            String s = (String) i.next();
            if (!s.contains("originalRoot")) {
//            if(!s.startsWith("originalRoot_")){
                i.remove();
            }
        }
        File path = null;
        for (int i = 0; i < al.size(); i++) {
            path = getFile(model.getEnv().get(al.get(i)) + "/" + relativePath);
            String pan = path.getPath().substring(0,path.getPath().indexOf(":")) ;
            File file1 = new File(pan+":"+File.separator) ;  //针对盘符判断空间

            if ((file1.getUsableSpace()) >= (file.length())) {

                if (file != null && !path.exists())
                    if (!path.mkdirs())
                        throw new RuntimeException("mkdir [" + relativePath + "] error");
                String fileName = original.getName();
                File f = getFile(path + File.separator + fileName);
                try {
                    if (f != null && f.exists() && !overWrite) {
                        String rename = rename(f, original.getName());
                        f = getFile(path + "/" + rename);
                        original.setName(rename);
                    }

                    FileCopyUtils.copy(file, f);
//                    fileSize = (int)file.length();
//                    filePath = path + File.separator + fileName ;
                    setFileSize((int)file.length());
                    setFilePath(path + File.separator + fileName);

                    logger.info("copy file"+System.currentTimeMillis());
                    original.setPath("${" + al.get(i) + "}/" + relativePath + "/" + original.getName());
                    original.setOwnerModelName(ownerModelName);
                    if (f != null)
                        original.setFileSize(f.length());
                    break;
                } catch (IOException ignored) {
                }
            } else {
                continue;
            }

        }
    }

    @Override
    public void saveOriginalFile(Original original, File file, String ownerModelName, boolean overWrite, String dirName) {
        Object owner = getOriginalOwner(ownerModelName,original.getOwnerId());
        Model model = modelService.getModel(owner).getParent();
        String relativePath = getRelativePath(owner, model);
        Collection set = model.getEnv().getParent().getProps().keySet();
        List<String> al = new ArrayList<String>();

        al.addAll(set);
        for (Iterator i = al.iterator(); i.hasNext(); ) {
            String s = (String) i.next();
            if (!s.contains("originalRoot")) {
                i.remove();
            }
        }
        File path = null;
        for (int i = 0; i < al.size(); i++) {
            path = getFile(model.getEnv().get(al.get(i)) + File.separator + relativePath+ File.separator+dirName);
            String pan = path.getPath().substring(0,path.getPath().indexOf(":")) ;
            File file1 = new File(pan+":"+File.separator) ;  //针对盘符判断空间

            if ((file1.getUsableSpace()) >= (file.length())) {
                if(path.exists()){
                    String fileName = original.getName();
                    File f = getFile(path + File.separator + fileName);
                    try {
                        if (f != null && f.exists() && !overWrite) {
                            String rename = rename(f, original.getName());
                            f = getFile(path + "/" + rename);
                            original.setName(rename);
                        }

                        FileCopyUtils.copy(file, f);
                        setFileSize((int)file.length());
                        setFilePath(path + File.separator + fileName);

                        logger.info("copy file"+System.currentTimeMillis());
                        if("".equals(dirName) || dirName==null){
                            original.setPath("${" + al.get(i) + "}/" + relativePath + "/" + original.getName());
                        }else {
                            original.setPath("${" + al.get(i) + "}/" + relativePath + "/" + dirName + "/" + original.getName());
                        }

                        original.setOwnerModelName(ownerModelName);
                        if (f != null)
                            original.setFileSize(f.length());
                        break;
                    } catch (IOException ignored) {
                    }
                }
            } else {
                continue;
            }

        }
    }

    /**
     * 获取文档一体化实体对象
     *
     * @param original
     * @return
     */
    public Object getEntity(Original original) {
        Object entity = entityService.load("ythsw", original.getOwnerId());
        if (entity == null)
            entity = entityService.load("ythfw", original.getOwnerId());
        if (entity == null)
            entity = entityService.load("ythnw", original.getOwnerId());
        return entity;
    }

    private String getRelativePath(Object owner, Model model) {
        String relativePath;
        if (owner instanceof Archive) {
            Archive archive = (Archive) owner;
            if (EnvHolder.isEnable(Switch.ORHINAL_OWNER_PATH)) {
                Model ownerModel = modelService.getModel(archive.getModelName());
                relativePath = new Environment(archive, ownerModel.getEnv()).get("ownerPath");
                if (relativePath == null)
                    relativePath = new Environment(archive, model.getEnv()).get("archivePath");
            } else {
                relativePath = new Environment(archive, model.getEnv()).get("archivePath");
            }
            if (relativePath == null) {
                relativePath = model.getEnv().getExpr("archive/${.now?string('yyyy/MM/dd')}/" + archive.getId());
            }
        } else if (owner instanceof Document) {
            Document doc = (Document) owner;
            if (doc.getArchiveId() != null) {
                Archive archive = archiveService.getSimpleArchive(doc.getArchiveId());
                if (EnvHolder.isEnable(Switch.ORHINAL_OWNER_PATH)) {
                    Model ownerModel = modelService.getModel(archive.getModelName());
                    relativePath = new Environment(archive, ownerModel.getEnv()).get("ownerPath");
                    if (relativePath == null)
                        relativePath = new Environment(archive, model.getEnv()).get("archivePath");
                } else {
                    relativePath = new Environment(archive, model.getEnv()).get("archivePath");
                }
                if (relativePath == null) {
                    relativePath = model.getEnv().getExpr("archive/${.now?string('yyyy/MM/dd')}/" + doc.getArchiveId() + "/" + doc.getId());
                } else {
                    relativePath += "/" + (doc.getYh() == null ? doc.getId() : doc.getYh());
                }
            } else {
                relativePath = model.getEnv().getExpr("document/${.now?string('yyyy/MM/dd')}/" + doc.getId());
            }
        } else {
            Object entity = owner;
            relativePath = new Environment(entity, model.getEnv()).get("genericPath");
            if (relativePath == null) {
                try {
                    relativePath = model.getEnv().getExpr("generic/${.now?string('yyyy/MM/dd')}/" + PropertyUtils.getProperty(entity, "id"));
                } catch (Exception e) {
                    relativePath = null;
                }
            }
        }
        if (relativePath == null)
            throw new RuntimeException("Original save path unset,please check");
        return relativePath;
    }

    @Transactional
    public Page<Original> searchOriginal(String ownerId, String name, int start, int limit) {
        if (originalPermissionService.isOriginalPermissionEnable()) {
            UserInfo user = SessionUtil.getCurrentUser();
            if (!user.isAdmin()) {
                return originalPermissionService.searchOriginal(ownerId, name, start, limit);
            }
        }
        List<Criterion> list = new ArrayList<Criterion>();
        list.add(Restrictions.eq("ownerId", ownerId));
        if (StringUtils.isBlank(name)) {
            syncOriginals(ownerId);
        } else {
            list.add(Restrictions.like("name", name, MatchMode.ANYWHERE));
        }
        return search(list, Collections.singletonList(Order.asc("name")), start, limit);
    }


    public boolean hasOriginal(String ownerId) {
        List<Original> list = find(Restrictions.eq("ownerId", ownerId));
        if (list.size() > 0)
            return true;
        return false;
    }

    public Object[] getIds(String ownerId) {
        List<Original> originals = createCriteria(Restrictions.eq("ownerId", ownerId)).addOrder(Order.asc("name")).list();
        List<String> ids = new ArrayList<String>();
        for (Original original : originals) {
            ids.add(original.getId());
        }
        return ids.toArray();
    }

    private void createThumbFile(Original original) {
        final String path = EnvHolder.getAppEnv().getExpr(original.getPath());
        if (!new File(path).exists())
            return;
        if (original.isImage() && original.getFileSize() < MAX_SIZE) {
            final String destPath = path + THUMB_PREFIX;
            try {
                if (original.getFileSize() > TASK_SIZE) {
                    taskExecutor.execute(new Runnable() {
                        public void run() {
                            try {
                                ImageUtils.resizeImage(path, destPath, MICRO_IMAGE_WIDTH, MICRO_IMAGE_HEIGHT);
                            } catch (Exception e) {
                                logger.error("Unable to transform image:[" + path + "] to [" + destPath + "]", e);
                            }
                        }
                    });

                } else {
                    ImageUtils.resizeImage(path, destPath, MICRO_IMAGE_WIDTH, MICRO_IMAGE_HEIGHT);
                }
            } catch (Exception ex) {
                logger.error("Unable to transform image:[" + path + "] to [" + destPath + "]", ex);
            }
        } else {
            if (previewServerUrl == null) {
                logger.warn("previewServerUrl not config");
                return;
            }
            taskExecutor.execute(new Runnable() {
                public void run() {
                    String url = null;
                    try {
                        url = previewServerUrl + "?path=" + URLEncoder.encode(path, "gbk");
                        HttpClient httpClient = new HttpClient();
                        HttpMethod method = new GetMethod(url);
                        if (httpClient.executeMethod(method) != HttpStatus.SC_OK)
                            logger.debug("Error to connect {}", url);
                        else
                            logger.debug("Get {} success", url);
                    } catch (Exception e) {
                        logger.error("Error to connect {" + url + "} " + e.getMessage());
                    }
                }
            });
        }
    }

    private void saveDownloadLog(Original original, String action) {
        UserInfo user = SessionUtil.getCurrentUser();
        if (user != null) {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("originalId", original.getId()));
            criterions.add(Restrictions.eq("userId", user.getId()));
            criterions.add(Restrictions.eq("action", action));
            Page<DownloadLog> page = search(DownloadLog.class, criterions, null, 0, 1);
            DownloadLog dl = null;
            if (!page.isEmpty()) {
                dl = page.getItem(0);
                if (DateUtils.addMinutes(dl.getDownloadTime(), 2).after(new Date())) {
                    dl.setCount(dl.getCount() + 1);
                } else {
                    dl = null;
                }
            }
            if (dl == null) {
                dl = new DownloadLog();
                dl.setOriginalId(original.getId());
                dl.setUserId(user.getId());
                dl.setUserName(user.getUsername());
                dl.setAction(action);
                dl.setCount(1);
            }
            dl.setDownloadTime(new Date());
            getSession().save(dl);
        }
    }

    private static File getFile(String path) {
        try {
            return ResourceUtils.getFile(path);
        } catch (Exception e) {
            logger.error("Get File error,path [" + path + "]", e);
        }
        return null;
    }

    private static String rename(File f, String fileName) {
        int index = fileName.lastIndexOf('.');
        String name = index > -1 ? fileName.substring(0, index) : fileName;
        String ext = index > -1 ? fileName.substring(index) : "";
        String name1 = fileName;
        for (int i = 1; new File(f.getParentFile(), name1).exists(); i++) {
            name1 = name + "_" + i + ext;
        }
        return name1;
    }

    @Override
    public boolean getUploadState(File uploadFile) {
        flag = false ;
        File file = getFile(getFilePath()) ;

        if(file.length() == getFileSize()){
            flag = true ;
            setFilePath("");
            setFileSize(-1);
        }

        return  flag ;
    }

    private Set<String> getAvailablePaths(List<Original> originals, String ownerId, String modelName){
        //根据原文路径判断可用的目录建立文件夹，否则按照配置的文件路径进行选择可用的路径进行创建目录
        Set<String> paths = new HashSet<String>();
        if(originals.size()>0){
            for(Original original : originals){
                final String path = EnvHolder.getAppEnv().getExpr(original.getPath());
                String url = path.substring(0, path.lastIndexOf("/"));
//                String pan = url.substring(0,url.indexOf(":")) ;
//                File file1 = new File(pan+":"+File.separator) ;  //针对盘符判断空间
//                if(file1.getUsableSpace() >0){
                    paths.add(url);
//                }
            }
        }else{
            Object owner = entityService.load(modelName,ownerId);
            Model model = modelService.getModel(modelName).getParent();
            String relativePath = getRelativePath(owner, model);
            Collection set = model.getEnv().getParent().getProps().keySet();
            List<String> al = new ArrayList<String>();

            al.addAll(set);
            for (Iterator i = al.iterator(); i.hasNext(); ) {
                String s = (String) i.next();
                if (!s.contains("originalRoot")) {
                    i.remove();
                }
            }

            for(int i = 0; i < al.size(); i++){
                String url = model.getEnv().get(al.get(i)) + File.separator + relativePath;
//                String pan = url.substring(0,url.indexOf(":")) ;
//                File file = new File(pan+":"+File.separator) ;  //针对盘符判断空间
//                if(file.getUsableSpace() > 0){
                    paths.add(url);
//                }
            }
        }

       return paths;
    }

    /***
     *
     * @param dirName    对应的路径
     * @param folderName 创建的文件夹名称
     * @param ownerId
     * @param modelName
     */
    @Override
    public void makeDir(String dirName, String folderName, String ownerId, String modelName) {
        List<Original> originals = this.getDbOriginals(ownerId);
        Set<String> paths = getAvailablePaths(originals, ownerId, modelName);
        Object owner = entityService.load(modelName,ownerId);
        Model model = modelService.getModel(modelName).getParent();
        String relativePath = getRelativePath(owner, model);

        File path = null;
        for (String url : paths) {
            String pan = url.substring(0, url.indexOf(":"));
            File file = new File(pan + ":" + File.separator);  //针对盘符判断空间
            if (file.getUsableSpace() > 0) {
                String[] str = url.split(relativePath);
                String newUrl = str[0]+relativePath + (("".equals(dirName)) ? ("/"+folderName) : ("/"+dirName+"/"+folderName));
                path = getFile(newUrl);
                if (!path.exists()) {
                    path.mkdirs();
                    break;
                }
            }
        }
    }

    /**
     * 界面获取所有的缩略图信息
     * @param ownerId
     * @param modelName
     * @param dirName
     * @return
     */
    @Override
    public Set<Map> getAllAcronymInfo(String ownerId, String modelName, String dirName) {
        List<Original> originals = getDbOriginals(ownerId);
//        syncOriginals(ownerId);
        Set<String> paths = getAvailablePaths(originals, ownerId, modelName);
        Object owner = entityService.load(modelName, ownerId);
        Model model = modelService.getModel(modelName).getParent();
        String relativePath = getRelativePath(owner, model);
        String[] files = null;
        String filePath = "";
        Set<Map> maps = new HashSet<Map>();

        for(String path : paths){
            String[] dirs = path.split(relativePath) ;
            if("".equals(dirName)){
                filePath = dirs[0]+relativePath;
            }else {
                filePath = dirs[0] + relativePath + File.separator + dirName;
            }

            File file = new File(filePath);

            if(file.exists()){
                files = file.list();
                for(String name : files){
                    Map map = new HashMap();
                    boolean isSame = false;

                    /**
                     * 检查重复的文件夹
                     */
                    for(Map map1 : maps){
                        if(Boolean.parseBoolean(map1.get("isFolder").toString()) && map1.get("name").equals(name)){
                            isSame = true;
                            break;
                        }
                    }

                    if(originals.size()==0 && !isSame){
                        map.put("name", name);
                        map.put("id", UUIDHexGenerator.generate());
                        map.put("isImage",false);
                        map.put("isDoc",false);
                        map.put("isFolder",true);
                        map.put("url", "");
                        map.put("size",0);
                        map.put("ownerId", ownerId);
                        map.put("sort",0);
                    }else if(originals.size()!=0 && !isSame){
                        for(Original original : originals){
                            if(name.equals(original.getName())){ //文件类型
                                map.put("name", name);
                                map.put("id",original.getId());
                                map.put("isImage",original.isImage());
                                map.put("isDoc",original.isXOffice());
                                map.put("isFolder",false);
                                map.put("url", "og!get.action?id="+original.getId());
                                map.put("size",original.getFileSize());
                                map.put("ownerId", original.getOwnerId());
                                map.put("sort",1);
                                break;
                            }else if(!name.contains(".")){  // 文件夹
                                map.put("name", name);
                                map.put("id", UUIDHexGenerator.generate());
                                map.put("isImage",false);
                                map.put("isDoc",false);
                                map.put("isFolder",true);
                                map.put("url", "");
                                map.put("size",0);
                                map.put("ownerId", ownerId);
                                map.put("sort",0);
                                break;
                            }
                        }
                    }
                    if(map.isEmpty())
                        continue;
                    maps.add(map);
                }
            }
        }
        return sortByName(maps);
    }

    private Set<Map> sortByName(final Set<Map> maps){
        List<Map> list = new ArrayList<Map>();
        Iterator iter = maps.iterator();
        int i = 1;

        while (iter.hasNext()){
            Map map = (Map)iter.next();
            if(!Boolean.parseBoolean(map.get("isFolder").toString())){
                list.add(map);
                iter.remove();
            }
        }

        Collections.sort(list, new Comparator<Map>() {
            @Override
            public int compare(Map o1, Map o2) {

                String name1 = o1.get("name").toString();
                String name2 = o2.get("name").toString();

                if(name1.matches("\\d*.\\w*") && name2.matches("\\d*.\\w*")){
                    return  Integer.parseInt(name1.split("\\.")[0]) - Integer.parseInt(name2.split("\\.")[0]);
                }else {
                    return name1.compareTo(name2);
                }
            }
        });

        for(Map item :list){
            item.remove("sort");
            item.put("sort",i++);
        }
        maps.addAll(list);
        return maps;
    }

    /**
     *
     * @param fromName 原始名称
     * @param toName   替换名称
     * @param ownerId
     * @param modelName
     * @param path     文件目录
     */
    @Override
    public void renameDir(String fromName, String toName, String ownerId, String modelName, String path) {
        List<Original> originals = getDbOriginals(ownerId);
        Set<String> paths = getAvailablePaths(originals, ownerId, modelName);
        Object owner = entityService.load(modelName,ownerId);
        Model model = modelService.getModel(modelName).getParent();
        String relativePath = getRelativePath(owner, model);

        syncDbPath(originals,fromName,toName,path,relativePath);

        for(String url : paths){
            String[] dirs = url.split(relativePath);
            String fromUrl = dirs[0] + relativePath +(("".equals(path)) ? ("/"+fromName +"/") : ("/"+path+"/"+fromName+"/"));
            String toUrl = dirs[0] + relativePath +(("".equals(path)) ? ("/"+toName +"/") : ("/"+path+"/"+toName+"/"));
            File from = getFile(fromUrl);

            if(from.exists()){
                File to = getFile(toUrl);
                from.renameTo(to);
            }
        }

    }

    /**
     * 当文件夹的名称改变时，对应的原文当中的所有相关文件夹名称也要改变
     * @param originals
     * @param fromName
     * @param toName
     * @param filePath
     * @param relativePath
     */
    @Transactional
    private void syncDbPath(List<Original> originals, String fromName, String toName, String filePath,String relativePath){
        String newPath = "";
        for(Original original : originals){
            String dbFullPath = original.getPath();
            String name = original.getName();
            String dbPath = dbFullPath.substring(0,dbFullPath.lastIndexOf(name));
            String[] str = dbPath.split(relativePath);

            //需要比对文件路径（为 基于根目录已进入的文件路径+正在修改的目录）
            String targerUlr = "".equals(filePath) ? "/"+fromName +"/" : "/"+filePath+"/"+fromName+"/";
            //替换的路径
            String updateUrl = "".equals(filePath) ? "/"+toName +"/" : "/"+filePath+"/"+toName+"/";

            if(str[1].startsWith(targerUlr)){
                if(str[1].length() == targerUlr.length()){
                    dbFullPath = str[0]+relativePath+updateUrl+name;
                }else{
                    dbFullPath = str[0]+relativePath+str[1].replaceFirst(targerUlr,updateUrl)+name;
                }
                original.setPath(dbFullPath);
                original.setUpdateTime(new Date());
                save(original);
                getSession().flush();
            }
        }
    }

    /**
     * 删除文件夹（包含删除里面的子文件夹和文件）
     * @param dirName
     * @param folderName
     * @param ownerId
     * @param modelName
     */
    @Override
    public void removeDir(String dirName, String folderName, String ownerId, String modelName) {
        List<Original> originals = getDbOriginals(ownerId);
        Set<String> paths = getAvailablePaths(originals, ownerId, modelName);
        Object owner = entityService.load(modelName,ownerId);
        Model model = modelService.getModel(modelName).getParent();
        String relativePath = getRelativePath(owner, model);

        File dir = null;

        for(String url : paths){
            String[] dirs = url.split(relativePath);
            if("".equals(dirName)){
                url = dirs[0] + relativePath + File.separator + folderName;
            }else{
                url = dirs[0] + relativePath + File.separator + dirName+File.separator+folderName;
            }

            dir = getFile(url);

            if(dir.exists()){
                deleteDir(dir);
                syncRemoveOriginals(originals,model);
            }
        }

    }

    /**
     * 递归删除文件夹和其子目录下的文件
     * @param dir
     * @return
     */
    private boolean deleteDir(File dir){
        if (dir.isDirectory()) {
            String[] children = dir.list();
            //递归删除目录中的子目录下
            for (int i=0; i<children.length; i++) {
                boolean success = deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
            }
        }
        // 目录此时为空，可以删除
        return dir.delete();
    }

    /**
     * 在文件夹的数据被删除之后，应该同步进行数据库的数据一致删除
     * @param originals
     */
    @Transactional
    private void syncRemoveOriginals(List<Original> originals, Model model){
        for(Original original : originals){
            String path = EnvHolder.getAppEnv().getExpr(original.getPath());
            File file = getFile(path);
            if(!file.exists()){ //物理文件不存在的都从数据库里删除
                delete(original);
                getSession().flush();
            }
        }
    }

    /**
     * 重命名原文文件
     * @param dirName    文件目录
     * @param fromName   原始名称
     * @param toName     改变名称
     * @param ownerId
     * @param modelName
     * @param originalId //原文id 用于修改指定的原文信息
     */
    @Override
    public void renameOriginal(String dirName, String fromName, String toName, String ownerId, String modelName, String originalId) {
        List<Original> originals = getDbOriginals(ownerId);
        Set<String> paths = getAvailablePaths(originals, ownerId, modelName);
        Object owner = entityService.load(modelName,ownerId);
        Model model = modelService.getModel(modelName).getParent();
        String relativePath = getRelativePath(owner, model);

        for(String url : paths){
            String[] dirs = url.split(relativePath);
            String fromUrl = dirs[0] + relativePath +(("".equals(dirName)) ? ("/"+fromName +"/") : ("/"+dirName+"/"+fromName+"/"));
            String toUrl = dirs[0] + relativePath +(("".equals(dirName)) ? ("/"+toName +"/") : ("/"+dirName+"/"+toName+"/"));
            File from = getFile(fromUrl);

            if(from.exists()){
                File to = getFile(toUrl);
                from.renameTo(to);
                break;
            }
        }

        /**
         * 修改数据库的原文名称
         */
        for(Original original : originals){
            if(original.getId().equals(originalId)){
                String path = original.getPath();
                String newPath = path.substring(0,path.lastIndexOf(original.getName()))+toName;
                original.setPath(newPath);
                original.setName(toName);
                original.setUpdateTime(new Date());
                save(original);
                getSession().flush();
                break;
            }
        }
    }
}
