package com.gtis.archive.service.impl;

import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
@Service
public class AjhRangeServiceImpl extends HibernateTemplate<AjhRange, String> implements AjhRangeService {
    @Autowired
    private SysUserService userService;

    public AjhRange getAjhRange(String id) {
        return get(id);
    }

    public String getModelNameByMlh(String mlh) {
        List<AjhRange> list = findBy("mlh", mlh);
        return list.isEmpty() ? null : list.get(0).getModelName();
    }

    @SuppressWarnings("unchecked")
    public List<AjhRange> getAjhRangeByModelName(String modelName) {
        Criteria criteria = null;
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH) && SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin())
            /**
             * 常州系统支持多业务共目录号，现溧阳档案参照常州也需要支持,查询ajhRange的时候溧阳与常州应该支持modelName模糊查询
             */
            if (EnvHolder.isEnable(Switch.CHANGZHOU) || EnvHolder.isEnable(Switch.LIYANG)) {
                criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"), Restrictions.eq("dwdm", getDwdm()));
            } else {
                if(EnvHolder.isEnable(Switch.JIN_TAN)&&(("Jhcw").equals(modelName)||"Swda".equals(modelName))){ //金坛这两个业务不区分单位代码
                    criteria = createCriteria(Restrictions.eq("modelName", modelName));
                }else{
                    criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", getDwdm()));
                }
            }
        else if (EnvHolder.isEnable(Switch.CHANGZHOU) || EnvHolder.isEnable(Switch.LIYANG)) {
            criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"));
        } else {
            criteria = createCriteria(Restrictions.eq("modelName", modelName));
        }
        if(SessionUtil.getCurrentUser()!=null&&SessionUtil.getCurrentUser().isAdmin()&&EnvHolder.isEnable(Switch.DWDM))
            return criteria.addOrder(Order.asc("dwdm"))
                    .addOrder(Order.asc("orderNumber"))
                    .addOrder(Order.asc("mlh"))
                    .list();
        return criteria
                .addOrder(Order.asc("orderNumber"))
                .addOrder(Order.asc("mlh"))
                .list();
    }

    public List<AjhRange> getAjhRangeByModelNameAndTerm(String modelName,String term){
        Criteria criteria = null;
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH) && SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin())
            if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
                criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"), Restrictions.eq("dwdm", getDwdm()));
            } else {
                if(EnvHolder.isEnable(Switch.JIN_TAN)&&(("Jhcw").equals(modelName)||"Swda".equals(modelName))){ //金坛这两个业务不区分单位代码
                    criteria = createCriteria(Restrictions.eq("modelName", modelName));
                }else{
                    if(term!=null) {
                        criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", getDwdm()), Restrictions.eq("term", term));
                    }else{
                        criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", getDwdm()), Restrictions.isNull("term"));
                    }
                }
            }
        else if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
            criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"));
        } else {
            if(term!=null){
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("term", term));
            }else{
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.isNull("term"));
            }
        }
        if(SessionUtil.getCurrentUser()!=null&&SessionUtil.getCurrentUser().isAdmin()&&EnvHolder.isEnable(Switch.DWDM))
            return criteria.addOrder(Order.asc("dwdm"))
                    .addOrder(Order.asc("orderNumber"))
                    .addOrder(Order.asc("mlh"))
                    .list();
        return criteria
                .addOrder(Order.asc("orderNumber"))
                .addOrder(Order.asc("mlh"))
                .list();
    }


    public Map<String, Integer> getAvailableAjhCountMap() {
        List<AjhRange> list = getAll();
        Map<String, Integer> map = new HashMap<String, Integer>();
        for (AjhRange range : list) {
            int i = getAvailableAjh(range);
            if (map.containsKey(range.getModelName())) {
                int count = map.get(range.getModelName());
                if (count != -1 && i != -1)
                    map.put(range.getModelName(), count + i);
            } else {
                map.put(range.getModelName(), i);
            }
        }
        return map;
    }

    public Map<String, Integer> getAvailableAjhCountMapByDwdm(String dwdm) {
        List<AjhRange> list = getAll();
        Map<String, Integer> map = new HashMap<String, Integer>();
        for (AjhRange range : list) {
            if(dwdm.equals(range.getDwdm())){
                int i = getAvailableAjh(range);
                if (map.containsKey(range.getModelName())) {
                    int count = map.get(range.getModelName());
                    if (count != -1 && i != -1)
                        map.put(range.getModelName(), count + i);
                } else {
                    map.put(range.getModelName(), i);
                }
            }
        }
        return map;
    }

    public AjhRange getAvailableAjhRange(String modelName) {
        List<AjhRange> list = getAjhRangeByModelName(modelName);
        for (AjhRange ajh : list) {
            if (EnvHolder.isEnable(Switch.JIN_TAN) && ajh.getYear() != null && ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(Calendar.YEAR))) && !ajh.hasExhausted())
                return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + getDwdm() + "】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvailableAjhRange(String modelName, Archive archive) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String term = (String) PropertyUtils.getProperty(archive, "jnmllx");

        List<AjhRange> list = getAjhRangeByModelNameAndTerm(modelName,term);
        for (AjhRange ajh : list) {
            if (EnvHolder.isEnable(Switch.JIN_TAN) && ajh.getYear() != null && ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(Calendar.YEAR))) && !ajh.hasExhausted())
                return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + getDwdm() + "】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    /**
     * 获取模型对应单位代码可以用的案卷号
     *
     * @param modelName
     * @param dwdm
     * @return
     */
    public AjhRange getAvailableAjhRangeByDwdm(String modelName, String dwdm) {
        Criteria criteria = createCriteria();
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
                criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"), Restrictions.eq("dwdm", dwdm));
            } else {
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm));
            }
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (EnvHolder.isEnable(Switch.JIN_TAN) && ajh.getYear() != null && ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(Calendar.YEAR))) && !ajh.hasExhausted())
                return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + dwdm + "】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    public AjhRange getAvailableAjhRange(String modelName, String mlh) {
        List<AjhRange> list = getAjhRangeByModelName(modelName);
        for (AjhRange ajh : list) {
            if (EnvHolder.isEnable(Switch.JIN_TAN) && ajh.getYear() != null && ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(Calendar.YEAR))) && !ajh.hasExhausted() && ajh.getMlh().equalsIgnoreCase(mlh))
                return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted() && ajh.getMlh().equalsIgnoreCase(mlh))
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】针对单位代码【" + getDwdm() + "】分配的目录号" + mlh + "不正确");
        throw new EntityNotFoundException("模型" + modelName + "配置的目录号" + mlh + "不存在！");
    }

    /**
     * 获取对应目录号
     *
     * @param modelName
     * @param dwdm
     * @param mlh
     * @return
     */
    public AjhRange getAvailableAjhRange(String modelName, String dwdm, String mlh) {
        Criteria criteria = createCriteria();
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH)) {
            if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
                criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"), Restrictions.eq("dwdm", dwdm), Restrictions.eq("mlh", mlh));
            } else {
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm), Restrictions.eq("mlh", mlh));
            }
        } else {
            if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
                criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"), Restrictions.eq("mlh", mlh));
            } else {
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("mlh", mlh));
            }
        }
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (EnvHolder.isEnable(Switch.JIN_TAN) && ajh.getYear() != null && ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(Calendar.YEAR))) && !ajh.hasExhausted())
                return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + dwdm + "】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Transactional
    public void removeAjhRange(String id) {
        delete(id);
    }

    @Transactional
    public AjhRange saveAjhRange(AjhRange ajhRange) {
        getSession().clear();
        save(ajhRange);
//        merge(ajhRange);
        return ajhRange;
    }

    /**
     * 获取指定页案卷号
     *
     * @param start
     * @param limit
     * @param order
     * @return
     */
    public Page<AjhRange> getAjhRanges(int start, int limit, Order[] order) {
        return search(start, limit, order);
    }

    /**
     * 获取案卷号将目录号转为数字型排序
     * @param start
     * @param limit
     * @param order
     * @return
     */
    public Page<AjhRange> getAjhRangesOrderMlh(int start, int limit, String order) {
        String baseSql="select * from t_ajh_range t where t.model_name!='Wdyth' order by cast(t.mlh as int) "+order;
        Page page = new Page(Page.toIndex(start, limit), limit);
        Query query = getSession().createSQLQuery(baseSql.toString()).addEntity(AjhRange.class);
        page.setItems(query.list());
        return page;
    }


    public AjhRange getAjhRangesForGeneric(String modelName, String mlh) {
        List<AjhRange> list = getAjhRangeByModelName(modelName);
        for (AjhRange ajh : list) {
            if (EnvHolder.isEnable(Switch.JIN_TAN) && ajh.getYear() != null && ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(Calendar.YEAR))) && ajh.getMlh().equalsIgnoreCase(mlh))
                return ajh;
        }
        for (AjhRange ajh : list) {
            if (ajh.getMlh().equalsIgnoreCase(mlh))
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】针对单位代码【" + getDwdm() + "】分配的目录号" + mlh + "不正确");
        throw new EntityNotFoundException("模型" + modelName + "配置的目录号" + mlh + "不存在！");
    }

    private List<AjhRange> getAjhRangeByModelNameDwdm(String modelName,String dwdm){
        Criteria criteria = null;
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH) && SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin())
            if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
                criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"), Restrictions.eq("dwdm", dwdm));
            } else {
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm));
            }
        else if (EnvHolder.isEnable(Switch.CHANGZHOU)) {
            criteria = createCriteria(Restrictions.like("modelName", "%" + modelName + "%"));
        } else {
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("dwdm", dwdm));
        }
        return criteria
                .addOrder(Order.asc("orderNumber"))
                .addOrder(Order.asc("mlh"))
                .list();
    }

    /**
     * 获取mlh列表
     * @param modelName
     * @return
     */
    public List getMlhByModelName(String modelName) {
       List<AjhRange> ajhList= getAjhRangeByModelName(modelName);
        List<String> mlhList=new ArrayList<String>();
        for(AjhRange ajhRange:ajhList){
            mlhList.add(ajhRange.getMlh());
        }
        return mlhList;
    }

    public List getMlh(String modelName, String dwdm) {
        List<AjhRange> ajhList= getAjhRangeByModelNameDwdm(modelName,dwdm);
        List<String> mlhList=new ArrayList<String>();
        for(AjhRange ajhRange:ajhList){
            mlhList.add(ajhRange.getMlh());
        }
        return mlhList;
    }

    /**
     *
     * @param modelName
     * @param bgqx
     * @return
     */
    public AjhRange getAjhRangesByBgqx(String modelName, String bgqx) {
        String dwdm=getDwdm();
        Criteria criteria = createCriteria();
        if(SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin()){
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("bgqx", bgqx),Restrictions.eq("dwdm", dwdm));
        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("bgqx", bgqx));
        }
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + dwdm + "】保管期限【"+bgqx+"】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public boolean exist(String mlh, String dwdm, String id, String year, String term) {
        Criteria criteria = createCriteria();
        if(EnvHolder.isEnable(Switch.DWDM)){
            if(StringUtils.isBlank(dwdm))
                dwdm=getDwdm();
            if(!"凭证".equals(term)){
                criteria = createCriteria(Restrictions.eq("dwdm", dwdm),Restrictions.eq("mlh", mlh));
            }else{
                criteria = createCriteria(Restrictions.eq("dwdm", dwdm),Restrictions.eq("mlh", mlh),Restrictions.eq("year",year));
            }
        }else{
            criteria = createCriteria(Restrictions.eq("mlh", mlh));
        }
        List<AjhRange> list =  criteria.list();
        if(list.size()>1){
            return true;
        }else if(list.size()==1){//如果id相同则为修改操作，非新增
            AjhRange dbAjhRange=list.get(0);
            if(dbAjhRange.getId().equals(id)){
                return false;
            }else{
                return true;
            }
        }else{
            return false;
        }
    }


    @Override
    public int getCurrentSxh(String modelName, String dwdm) {
        Criteria criteria = createCriteria();
        if(EnvHolder.isEnable(Switch.DWDM)){
            if(StringUtils.isBlank(dwdm))
                dwdm=getDwdm();
            if(EnvHolder.isEnable(Switch.JIN_TAN)&&("Jhcw".equals(modelName)||"Swda".equals(modelName))){
                criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.isNotNull("orderNumber"));
            }else {
                criteria = createCriteria( Restrictions.eq("dwdm", dwdm),Restrictions.eq("modelName", modelName),Restrictions.isNotNull("orderNumber"));
            }

        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName));
        }
        List<AjhRange> list=criteria .addOrder(Order.asc("orderNumber")).list();
        if(list!=null&&list.size()>0){
            if(list.get(list.size()-1).getOrderNumber()!=null)
                return list.get(list.size()-1).getOrderNumber()+1;

        }else{
            return 0;
        }
        return 0;
    }

    @Override
    public boolean searchAjhRange(String modelName, String dwdm, int orderNumber,String id) {
        Criteria criteria = createCriteria();
        if(EnvHolder.isEnable(Switch.DWDM)){
            if(StringUtils.isBlank(dwdm))
                dwdm=getDwdm();
            criteria = createCriteria( Restrictions.eq("dwdm", dwdm),Restrictions.eq("modelName", modelName),Restrictions.eq("orderNumber", orderNumber));
        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.eq("orderNumber", orderNumber));
        }
        List<AjhRange> list=criteria.list();
        if(list!=null&&list.size()>1){
            return true;
        }else if(list.size()==1&&!list.get(0).getId().equals(id)){
            return true;
        }
        return false;
    }

    @Override
    public AjhRange getAjhRangeByNdBgqx(String modelName, String bgqx, String nd) {
        String dwdm=getDwdm();
        Criteria criteria = createCriteria();
        if(SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin()){
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("bgqx", bgqx),Restrictions.eq("dwdm", dwdm),Restrictions.eq("year", nd));
        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("bgqx", bgqx),Restrictions.eq("year", nd));
        }
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + dwdm + "】保管期限【"+bgqx+"】年度【"+nd+"】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvailableAjhRangByNd(String modelName, String nd) {
        String dwdm=getDwdm();
        Criteria criteria = createCriteria();
        if(SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin()){
            criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.eq("dwdm", dwdm),Restrictions.eq("year", nd));
        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("year", nd));
        }
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未针对单位代码【" + dwdm + "】年度【"+nd+"】分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvailableAjhRangeByMlh(String modelName, String mlh) {
        Criteria criteria = createCriteria();
        criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.eq("mlh", mlh));
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未分配对应目录号【"+mlh+"】");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvailableAjhRangeNo(String modelName, String mlh, String nd) {
        Criteria criteria = createCriteria();
        criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.ne("mlh", mlh),Restrictions.eq("year", nd));
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未分配对应目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvailableAjhRangeByLb(String modelName, String term) {
        Criteria criteria = createCriteria();
        criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.eq("term", term),Restrictions.eq("dwdm", getDwdm()));
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未分配对应【"+term+"】目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvailableAjhRange(String modelName, boolean isPz, String nd, String term) {
        Criteria criteria = createCriteria();
        if(isPz){
            if("凭证".equals(term)) {
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("term", term), Restrictions.eq("year", nd), Restrictions.eq("dwdm", getDwdm()));
            }else{//现金日记账和明细不使用年度的目录号配置，只按照顺序号获取可用案卷号
                criteria = createCriteria(Restrictions.eq("modelName", modelName), Restrictions.eq("term", term), Restrictions.eq("dwdm", getDwdm()));
            }
        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.ne("term", "凭证"),Restrictions.eq("year", nd),Restrictions.eq("dwdm", getDwdm()));
        }
        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未分配对应【"+term+"】目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }

    @Override
    public AjhRange getAvaliableAjhRangeByJnmllx(String modelName, String jnmllx) {
        Criteria criteria = createCriteria();
        if(EnvHolder.isEnable(Switch.DWDM)){
            String dwdm = dwdm=getDwdm();
            criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.eq("term", jnmllx),Restrictions.eq("dwdm", getDwdm()));
        }else{
            criteria = createCriteria(Restrictions.eq("modelName", modelName),Restrictions.eq("term", jnmllx));
        }

        List<AjhRange> list = criteria.addOrder(Order.asc("orderNumber")).addOrder(Order.asc("mlh")).list();
        for (AjhRange ajh : list) {
            if (!ajh.hasExhausted())
                return ajh;
        }
        if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
            throw new EntityNotFoundException("模型【" + modelName + "】未分配对应【"+jnmllx+"】目录号");
        throw new EntityNotFoundException("模型" + modelName + "没有可用的目录号");
    }


    private int getAvailableAjh(AjhRange ajhRange) {
        if (ajhRange.getMaxValue() == null)
            return -1;
        if (ajhRange.getMaxValue() <= ajhRange.getCurrentValue())
            return 0;
        else
            return ajhRange.getMaxValue() - ajhRange.getCurrentValue();
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
