package com.gtis.archive.service;

import com.gtis.archive.entity.Original;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-30
 */
public interface OriginalService {
    /**
     * 根据id获取原文
     *
     * @param id 原文id
     * @return 原文
     */
    Original getOriginal(String id);

    /**
     * 删除原文
     *
     * @param ids 原文id列表
     */
    void removeOriginal(String[] ids);

    /**
     * 保存原文
     *
     * @param original 原文
     */
    void saveOriginal(Original original);

    /**
     * 根据所有者获取原文
     *
     * @param ownerId 所有者id
     * @return 原文列表
     */
    List<Original> getOriginals(String ownerId);

    /**
     * 获取原文的所有者对象
     *
     * @param id 原文id
     * @return 所有者对象
     */
    Object getOriginalOwner(String id);

    /**
     * 获取原文文件
     *
     *
     * @param id 原文id
     * @param action
     * @return 预览文件
     */
    File getOriginalFile(String id, String action);

    /**
     * 获取原文的预览文件
     *
     * @param id 原文id
     * @return 预览文件
     */
    File getOriginalThumbFile(String id);

    /**
     * 保存原文文件
     *
     * @param original  原文
     * @param file      文件
     * @param overWrite 是否覆盖
     */
    void saveOriginalFile(Original original, File file, boolean overWrite);

    /**
     * 保存原文
     * @param original
     * @param file
     * @param ownerModelName
     * @param overWrite
     */
    void saveOriginalFile(Original original, File file, String ownerModelName, boolean overWrite);

    /**
     * 保存原文(缩略图方式存储，需要添加目录的结构)
     * @param original
     * @param file
     * @param ownerModelName
     * @param overWrite
     * @param dirName
     */
    void saveOriginalFile(Original original, File file, String ownerModelName, boolean overWrite, String dirName);

    /**
     * 检索原文
     *
     * @param ownerId 所属
     * @param name     名称
     * @param start      位置
     * @param limit      分页大小
     * @return 原文分页对象
     */
    Page<Original> searchOriginal(String ownerId, String name, int start, int limit);

    /**
     * 是否存在原文
     * @param ownerId
     * @return
     */
    boolean hasOriginal(String ownerId);

    Object[] getIds(String ownerId);

    boolean getUploadState(File file) ;

    /**
     * 创建原文的子文件夹
     * @param dirName    对应的路径
     * @param folderName 创建的文件夹名称
     * @param ownerId
     * @param modelName
     */
    public void makeDir(String dirName, String folderName, String ownerId, String modelName);

    /**
     * 获取缩略图信息
     * @param ownerId
     * @param modelName
     * @param dirName
     * @return
     */
    public Set<Map> getAllAcronymInfo(String ownerId, String modelName, String dirName);

    /**
     * 要更改的名字
     * @param formName 原始名称
     * @param toName   替换名称
     * @param ownerId
     * @param modelName
     * @param path
     */
    public void renameDir(String formName, String toName, String ownerId, String modelName, String path);

    /**
     * 删除文件夹（包含删除里面的子文件夹和文件）
     * @param dirName
     * @param folderName
     * @param ownerId
     * @param modelName
     */
    public void removeDir(String dirName, String folderName, String ownerId, String modelName);

    /**
     * 重命名原文
     * @param dirName    文件目录
     * @param fromName   原始名称
     * @param toName     改变名称
     * @param ownerId
     * @param modelName
     */
    public void renameOriginal(String dirName, String fromName, String toName, String ownerId, String modelName, String originalId);

}
