<@layout.html import="ext,jquery,base,main">
<div id="archivesCt"></div>
<textarea style="display:none;" id="archiveTpl">
    <table style="width:100%;" class="a-table" cellpadding="0" cellspacing="0">
        <tr>
            <#list showFields?keys as name>
                <#assign width=showFields[name]['width']!-1/>
                <th<#if width!=-1> style="width:${width}px;"</#if>>${fields[name].title}</th>
            </#list>
                <th style="width:30px;"></th>
        </tr>
        <tpl for=".">
            <tr class='a-item {[xindex%2==0?"even":"odd"]}'>
                <#list showFields?keys as name>
                    <#assign fd=showFields[name]/>
                    <#assign max=fd['max']!-1/>
                    <td>
                        <#if name==linkField>
                            <a href="#" onclick="return showArchive('{id}');">{${name}:def("无"<#if max!=-1>,${max}</#if>)}</a>
                        <#elseif name=='state'><#if ctx.env['classifyViewMode']=='checkbox'>{state:format}<#else></#if>
                        <#else>{${name}:<#if fd['date']??>renderDate("${fd['date']}")<#else>def<#if max!=-1>("",${max})</#if></#if>}
                        </#if>
                    </td>
                </#list>
                    <td><a class="jn-btn" href="#"  onclick="return showOriginal(null,'{id}');" title="原文管理">原文</a></td>
            </tr>
            <tr style="display:none;" class="odd">
                <td colspan="7">
                    <div id="d{id}" class="a-ct"></div>
                </td>
            </tr>
        </tpl>
    </table>
</textarea>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript">
    var store,win,modelName='${modelName}';
    var _jsessionid = '${sessionId}';
    store = new Ext.data.JsonStore({
        url:'archive!list.action?modelName=${modelName}&id=${id}',
        root:'items',
        totalProperty:'totalCount',
        fields:[
            'id','hasOriginal',<#list showFields?keys as name>, '${name}'</#list>
        ]
    });
    store.load();
    var tpl = Ext.XTemplate.from('archiveTpl');
    var dv = new Ext.DataView({
        store:store,
        tpl:tpl,
        autoHeight:true,
        overClass:'x-view-over',
        itemSelector:'tr.a-item',
        emptyText:'',
        renderTo:'archivesCt'
    });

    Ext.util.Format.style=function(v){
        if(!v)
            return "<img src=\"/archive/img/wuog.png\" alt=\"未上传原文\"  title=\"未上传原文\" class='img' />";
        return null;
    }

function showArchive(id) {
    win = new Ext.Window({
        title:id ? '编辑档案' : '添加档案',
        closable:true,
        modal:true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive-entity.action?modelName=' + modelName + '&id=' + id  + '" id="archiveFrame"></iframe>'
    });
    win.show();
    return false;
}

  function onResize(w, h ) {
      win.setWidth(w + 40);
      win.setHeight(h + 90);
      win.center();
  }

    var ogDs;
  function showOriginal(archiveId, id) {
        ogDs = new Ext.data.JsonStore({
            url:'og!list.action?ownerId=' + id,
            autoLoad:true,
            totalProperty:'totalCount',
            root:'items',
            fields:[
                'id', 'name', 'fileSize', 'updateTime'
            ]
        });
        var ogSm = new Ext.grid.CheckboxSelectionModel();
        var formatSize = function (size, p, record) {
            return Ext.util.Format.fileSize(size);
        };
        var ogGrid = new Ext.grid.GridPanel({
            cls:'og',
            border:true,
            ds:ogDs,
            height:250,
            sm:ogSm,
            loadMask:true,
            stripeRows:true,
            region:'center',
            bbar:new Ext.PagingToolbar({
                pageSize:20, //每页显示几条数据
                store:ogDs,
                displayInfo:true,
                displayMsg:'{0} - {1} 共 {2} 条',
                emptyMsg:"没有记录返回" }),
            cm:new Ext.grid.ColumnModel([
                //new Ext.grid.RowNumberer(),//显示行号
                ogSm,
                {header:"名称", width:400, sortable:true, dataIndex:'name'},
                {header:"大小", width:100, sortable:true, dataIndex:'fileSize', renderer:formatSize},
                {header:"上传时间", width:150, sortable:true, dataIndex:'updateTime'}
            ]),
            tbar:[
                {
                    text:'查看',
                    iconCls:'preview',
                    handler:function () {
                        if (ogSm.getSelections().length == 0) {
                            Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                            return;
                        }
                        var nids = [];
                        for (var i = 0; i < ogSm.getSelections().length; i++) {
                            nids.push(ogSm.getSelections()[i].data.id);
                        }
                        showPreview(nids);
                    }
                }
            ],
            listeners:{
                rowdblclick:function (g, index, e) {
                        var id = ogDs.getAt(index).id;
                        showPreview([id]);
                },
                render:function (g) {
                    var store = g.getStore();
                    var view = g.getView();
                    g.tip = new Archive.OgTip({
                        dismissDelay:0,
                        target:view.mainBody,
                        delegate:'.x-grid3-row',
                        autoWidth:!Ext.isIE6,
                        renderTo:document.body,
                        listeners:{
                            beforeshow:function (tip) {
                                var rowIndex = view.findRowIndex(tip.triggerElement);
                                tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                            }
                        }
                    });
                }
            }
        });
        var ogWin = new Ext.Window({
            title:'原文',
            closable:true,
            modal:true,
            width:700,
            height:500,
            layout:'fit',
            border:false,
            resizable:false,
            buttons:[
                {
                    text:'关闭',
                    handler:function () {
                        ogWin.close();
                    }
                }
            ],
            items:ogGrid
        });
        ogWin.show();
        return false;
    }

    function showPreview(nids) {
        if (!Ext.isDefined(window.hasEPreOcx)) {
            try {
                new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                window.hasEPreOcx = true;
            } catch (e) {
                window.hasEPreOcx = false;
            }
        }
        if (window.hasEPreOcx) {
            var base = location.href.substring(0, location.href.lastIndexOf('/'));
            var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
            link = link.substr(link.indexOf('//') + 2);
            Ext.Ajax.request({
                url:'archive!cacheIds.action',
                params:{id:nids},
                success:function (r) {
                    debugger;
                    var json = Ext.decode(r.responseText);
                    location.href = 'epre://'+link + json['idsKey'];
                }
            });
        } else {
            window.open('og!get.action?preview=true&id=' + nids[0]);
        }
    }

    function getJsessionidUrl(url) {
        var index = url.indexOf('?');
        if (index > -1) {
            return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
        } else {
            return url + ';jsessionid=' + _jsessionid;
        }
    }
</script>
</@layout.html>