<@layout.admin import="ext">
<@layout.style name="js/ext/ux/treegrid.css"/>
<@layout.script name="js/ext/ux/TreeGridSorter.js"/>
<@layout.script name="js/ext/ux/TreeGridColumnResizer.js"/>
<@layout.script name="js/ext/ux/TreeGridNodeUI.js"/>
<@layout.script name="js/ext/ux/TreeGridLoader.js"/>
<@layout.script name="js/ext/ux/TreeGridColumns.js"/>
<@layout.script name="js/ext/ux/TreeGrid.js"/>
<div style="color:#666;padding:5px;">权限是继承的，选择了父节点，所属的子节点自动继承权限</div>
<div id="treeBox"></div>
<textarea id="permission-tpl" style="display:none;">
    <div style="padding:3px;"><tpl for="data"><input type="checkbox" name="{name}" class="perm-box" <tpl if="checked"> checked="checked"</tpl>>{text}&nbsp;</tpl></div>
</textarea>
<script type="text/javascript">
    $(function() {
        var json =${treeJson};
        var w = Ext.fly('treeBox').getWidth() - 10;
        var tree = new Ext.ux.tree.TreeGrid({
            enableSort:false,
            renderTo:'treeBox',
            autoHeight: true,
            width:w,
            columns:[
                {
                    header: '分类',
                    dataIndex: 'text',
                    width:w * 0.4
                },
                {
                    header: '权限',
                    dataIndex: 'data',
                    width:w * 0.55,
                    tpl:Ext.XTemplate.from('permission-tpl')
                }
            ],
            tbar:[
                {
                    id:'savePermission',
                    iconCls:'edit-node',
                    text:'保存',
                    handler: function() {
                        var checked = [],unChecked = [];
                        Ext.each(Ext.query('#treeBox input.perm-box'), function(box) {
                            if (box.checked)
                                checked.push(box.name);
                            else
                                unChecked.push(box.name);
                        });
                        Ext.Ajax.request({
                            url : 'permission!save.action?roleId=${roleId}',
                            params : {checked :checked,unChecked:unChecked},
                            success : function(rp) {
                                Ext.MessageBox.alert('提示', '　　保存成功!　　');
                            },
                            failure:function(rp) {
                                Ext.MessageBox.alert('提示', '　　保存失败!　　');
                            }
                        });
                    },
                    scope: this
                },
                {
                    iconCls:'back-node',
                    text:'返回',
                    handler: function() {
                        location.href = 'permission.action';
                    },
                    scope: this
                }
            ],
            root:new Ext.tree.AsyncTreeNode({
                id:'rootNode',
                text: '根分类',
                iconCls:'root',
                children:json
            })
        });
        tree.getRootNode().expand(false, false);
    });
</script>
</@layout.admin>