<@layout.admin import='ext'>
<style type="text/css">
    progress{
        height: 16px;
    }
</style>

<div id='pageDiv'></div>
<div id='pageTool'></div>
<textarea id='mlhContainer' style="display:none">
    <table cellpadding="0" cellspacing="0" class="list-table" style="width: 100%;margin-top: 20px">
        <#if ctx.hasEnv("changzhou.enable") || ctx.hasEnv("liyang.enable")>
            <caption><a href="mlh!edit.action" class="a-btn">新建多业务目录</a> </caption>
        </#if>
        <tr>
            <th style="width: 40px;">顺序号</th>
            <th>目录号</th>
            <th>分配业务</th>
            <th>最小值</th>
            <th>最大值</th>
            <th>可用数量</th>
            <th style="width: 60px;">是否用完</th>
            <th><a href="#"  onclick="sortByField('dwdm');">单位代码</a></th>
            <th style="width: 120px;">使用情况</th>
            <th style="width: 80px;">操作</th>
        </tr>
        <tpl for=".">
            <tr class='a-item {[xindex%2==0?"even":"odd"]}'>
                <td>{#}</td>
                <td style="font-size: 12px;font-weight: bold;color: #1886cf">{mlh}</td>
                <#if  ctx.hasEnv("jiangyin.enable")>
                    <td>{modelName:this.reNameModel}</td>
                <#else ><td>{modelName}</td></#if>
                <td>{minValue}</td>
                <td>{maxValue}</td>
                <td>{maxValue:this.remainValue}</td>
                <td style="font-size: 12px;font-weight: bold;">{maxValue:this.isOutOfUse}</td>
                <td>{dwdm}</td>
                <td id="infoDiv">{maxValue:this.getProgressInfo}</td>
                <td><a href="ajh!list.action?modelName={modelName}">维护</a></td>
            </tr>
        </tpl>
    </table>
</textarea>

<script type="text/javascript">
    var modelsMap=${modelsMap!'{}'};
    var order = 'ASC';
    function sortByField(field){
        debugger;
        store.singleSort(field,order);
        order = (order=='ASC'?'DESC':'ASC');
    }

    var store = new Ext.data.JsonStore({
        url:'mlh!list.action',
        root:'items',
        totalProperty:'totalCount',
        autoLoad:true,
        fields:['id','modelName','dwdm','mlh','minValue','maxValue','currentValue'],
        baseParams:{'limit':30}
    });

    var tpl = Ext.XTemplate.from('mlhContainer');

    var dataView = new Ext.DataView({
        store:store,
        tpl:tpl,
        autoHeight:true,
        overClass:'x-view-over',
        emptyMsg:'',
        itemSelector:'tr.a-item',
        renderTo:'pageDiv'
    });

    var toolBar = new Ext.PagingToolbar({
        renderTo:'pageTool',
        pageSize: 30,
        store:store,
        displayInfo:true,
        displayMsg:'{0} - {1} 共 {2} 条',
        emptyMsg:"没有记录返回"
    });

    tpl.reNameModel = function(value,all){
        if(modelsMap[value]==null)
            return value;
        return modelsMap[value];
    }

    tpl.remainValue = function(value,all){
        var remain = value-all.currentValue-all.minValue;
        return remain>0?remain:0;
    };

    tpl.isOutOfUse = function(value,all){
        var remain = value-all.currentValue-all.minValue;
        return remain>0?'<span style="color: #1886cf">否</span>':'<span style="color: #ff0000">是</span>';
    }

    tpl.getProgressInfo = function(value,all){
        var v= 100*(all.currentValue+all.minValue)/value;
        v = v.toFixed(1);
        return '<progress min="0" max="100" value="'+v+'"><span>'+v+'%</span></progress>';
    }


</script>
</@layout.admin>