/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web.admin;

import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="toList", location="ajh!list.action?modelName=${modelName}", type="redirect")})
public class AjhAction
extends ActionSupport {
    private static final long serialVersionUID = 7582278548353967361L;
    private String id;
    private String modelName;
    private AjhRange ajhRange;
    private List<AjhRange> ajhRanges;
    private Map<String, Integer> modelsMap;
    private Map<String, String> modelAliasMap;
    private Map<String, String> flMap;
    private String msg;
    private String mlh;
    private String dm;
    private String year;
    private String term;
    private List<String> bgqxs;
    private List<Map<String, String>> lbs;
    private List<String> lxs;
    private List<Map<String, String>> jnmllx;
    @Autowired
    private ModelManager modelService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    protected DictService dictService;

    public String getMlh() {
        return this.mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getDm() {
        return this.dm;
    }

    public void setDm(String dm) {
        this.dm = dm;
    }

    public AjhRange getAjhRange() {
        return this.ajhRange;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public List<AjhRange> getAjhRanges() {
        return this.ajhRanges;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Map<String, Integer> getModelsMap() {
        return this.modelsMap;
    }

    public Map<String, String> getModelAliasMap() {
        return this.modelAliasMap;
    }

    public Map<String, String> getFlMap() {
        return this.flMap;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public List<String> getBgqxs() {
        List items = this.dictService.getItems("bgqx");
        this.bgqxs = new ArrayList();
        for (Item item : items) {
            this.bgqxs.add(item.getValue());
        }
        return this.bgqxs;
    }

    public List<Map<String, String>> getJnmllx() {
        this.jnmllx = new ArrayList();
        boolean hasJnmllx = true;
        String dictName = "";
        Model model = this.modelService.getModel(this.modelName);
        Set fields = model.getFields();
        for (Field field : fields) {
            if (!"jnmllx".equals(field.getName())) continue;
            hasJnmllx = true;
            dictName = field.getValueDict();
        }
        if (hasJnmllx && !StringUtils.isBlank((String)dictName)) {
            List items = this.dictService.getItems(dictName);
            for (Item item : items) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", item.getName());
                map.put("value", item.getValue());
                this.jnmllx.add(map);
            }
        }
        return this.jnmllx;
    }

    public List<Map<String, String>> getLbs() {
        List items = this.dictService.getItems("lb");
        this.lbs = new ArrayList();
        for (Item item : items) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", item.getName());
            map.put("value", item.getValue());
            this.lbs.add(map);
        }
        return this.lbs;
    }

    public List<String> getLxs() {
        List items = this.dictService.getItems("cwlx");
        this.lxs = new ArrayList();
        for (Item item : items) {
            this.lxs.add(item.getValue());
        }
        return this.lxs;
    }

    public String execute() throws Exception {
        this.modelsMap = new LinkedHashMap();
        this.modelAliasMap = new HashMap();
        Map map = (EnvHolder.isEnable((String)"jurong.enable") || EnvHolder.isEnable((String)"jintan.enable")) && EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin() ? this.ajhRangeService.getAvailableAjhCountMapByDwdm(this.getDwdm()) : this.ajhRangeService.getAvailableAjhCountMap();
        if (EnvHolder.isEnable((String)"jiangyin.enable")) {
            this.flMap = new HashMap();
            List temp = this.treeService.getTree(null, new String[]{"model"});
            for (Map parentNode : temp) {
                String fl = parentNode.get("text").toString();
                ArrayList children = (ArrayList)parentNode.get("children");
                for (Map model : children) {
                    Model tempModel = this.modelService.getModelAllowNull(model.get("name").toString());
                    if (tempModel == null) continue;
                    this.modelsMap.put(tempModel.getName(), map.get(tempModel.getName()));
                    this.modelAliasMap.put(tempModel.getName(), tempModel.getTitle());
                    this.flMap.put(tempModel.getName(), fl);
                }
            }
        } else {
            for (Model model : this.modelService.getModels()) {
                if ("Archive".equals(model.getParentName())) {
                    this.modelsMap.put(model.getName(), map.get(model.getName()));
                    this.modelAliasMap.put(model.getName(), model.getTitle());
                    continue;
                }
                if (!EnvHolder.isEnable((String)"jiangyin.enable") || model.getParentName() != null) continue;
                this.modelsMap.put(model.getName(), map.get(model.getName()));
                this.modelAliasMap.put(model.getName(), model.getTitle());
            }
        }
        return super.execute();
    }

    public String edit() throws Exception {
        if (this.ajhRange == null) {
            if (StringUtils.isNotBlank((String)this.id)) {
                this.ajhRange = this.ajhRangeService.getAjhRange(this.id);
                this.modelName = this.ajhRange.getModelName();
            } else {
                this.ajhRange = new AjhRange();
                this.ajhRange.setModelName(this.modelName);
            }
        } else {
            if (this.ajhRange.getCurrentValue() < this.ajhRange.getMinValue()) {
                this.ajhRange.setCurrentValue(this.ajhRange.getMinValue());
            }
            if (StringUtils.isBlank((String)this.ajhRange.getId())) {
                this.ajhRange.setId(null);
            }
            if (EnvHolder.isEnable((String)"jintan.enable")) {
                if (!"Swda".equals(this.modelName) && this.ajhRangeService.exist(this.ajhRange.getMlh(), this.ajhRange.getDwdm(), this.ajhRange.getId(), this.ajhRange.getYear(), this.ajhRange.getTerm())) {
                    this.msg = "exist";
                    return "edit";
                }
                if (this.ajhRangeService.searchAjhRange(this.modelName, this.ajhRange.getDwdm(), this.ajhRange.getOrderNumber().intValue(), this.ajhRange.getId())) {
                    this.msg = "orderNumberExist";
                    return "edit";
                }
            }
            if (EnvHolder.isEnable((String)"dwdm.enable") && this.ajhRange.getDwdm() == null && (!EnvHolder.isEnable((String)"jintan.enable") || !"Jhcw".equals(this.modelName) && !"Swda".equals(this.modelName))) {
                this.ajhRange.setDwdm(this.getDwdm());
            }
            this.ajhRangeService.saveAjhRange(this.ajhRange);
            this.msg = "successed";
        }
        return "edit";
    }

    public String getTab() {
        return "ajh";
    }

    public String list() throws Exception {
        this.ajhRanges = this.ajhRangeService.getAjhRangeByModelName(this.modelName);
        if (EnvHolder.isEnable((String)"jintan.enable") && "Swda".equals(this.modelName)) {
            List items = this.dictService.getItems("lb");
            for (AjhRange ajhRange1 : this.ajhRanges) {
                String value = ajhRange1.getTerm();
                for (Item item : items) {
                    if (!item.getValue().equals(value)) continue;
                    ajhRange1.setTerm(item.getName());
                }
            }
        }
        return "list";
    }

    public String remove() throws Exception {
        this.ajhRangeService.removeAjhRange(this.id);
        return "toList";
    }

    public String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String validateMlh() {
        if (EnvHolder.isEnable((String)"jintan.enable") && this.modelName.equals("Swda")) {
            Struts2Utils.renderJson((String)"false", (String[])new String[0]);
            return null;
        }
        if (this.ajhRangeService.exist(this.mlh, this.dm, this.id, this.year, this.term)) {
            Struts2Utils.renderJson((String)"true", (String[])new String[0]);
        } else {
            Struts2Utils.renderJson((String)"false", (String[])new String[0]);
        }
        return null;
    }

    public String currentSxh() {
        Struts2Utils.renderJson((Object)this.ajhRangeService.getCurrentSxh(this.modelName, this.dm), (String[])new String[0]);
        return null;
    }
}

