/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayAction
implements Action {
    @Autowired
    private GatewayService gatewayService;
    @Autowired
    private DictService dictService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    protected ModelService modelService;
    private String data;
    private String id;
    private String modelName;
    private String mlh;
    private Map docShowFields;
    private Map docFields;
    private String tm;
    private String linkField;
    private Map showFields;

    public String getLinkField() {
        if (this.linkField == null) {
            try {
                this.linkField = this.archiveService.getArchiveModel(this.modelName).getTemplate("linkField");
            }
            catch (Exception ex) {
                this.linkField = "tm";
            }
        }
        return this.linkField;
    }

    public Map getShowFields() {
        if (this.showFields == null) {
            this.showFields = (Map)JSON.parseObject((String)this.getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return this.showFields == null ? Collections.emptyMap() : this.showFields;
    }

    public boolean getIsShowArchiveDoc() {
        try {
            if (this.modelService.getModel(this.modelName.concat("_jn")) != null) {
                return true;
            }
        }
        catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    public Map<String, Field> getFields() {
        return this.getEntityModel().getInheritfieldsMap();
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getTm() {
        return this.tm;
    }

    public void setTm(String tm) {
        this.tm = URLDecoder.decode(tm);
    }

    public String execute() throws Exception {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.in(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String update() {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.update(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String preIn() throws Exception {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.preIn(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String preDispose() {
        try {
            this.gatewayService.preDispose(this.modelName, this.id, this.mlh);
            Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        }
        catch (Exception ex) {
            Struts2Utils.renderJson((String)ex.toString(), (String[])new String[0]);
        }
        return null;
    }

    public String cancelDispose() {
        try {
            this.gatewayService.cancelDispose(this.modelName, this.id);
            Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String dispose() {
        try {
            Struts2Utils.renderJson((String)this.gatewayService.dispose(this.modelName, this.id), (String[])new String[0]);
        }
        catch (Exception ex) {
            Struts2Utils.renderJson((String)ex.toString(), (String[])new String[0]);
        }
        return null;
    }

    public String edit() {
        return "edit";
    }

    public String originalInfo() {
        return "originalInfo";
    }

    public String originalInfoByTm() throws IOException {
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        ArrayList orders = new ArrayList();
        Archive archive = null;
        criterions.add(Restrictions.like((String)"tm", (Object)("%" + this.tm + "%")));
        List archives = this.archiveService.searchArchiveList(this.modelName, criterions, orders, -1, -1);
        if (archives.size() >= 1) {
            archive = (Archive)archives.get(0);
            this.setId(archive.getId());
        } else {
            this.setId("");
        }
        return "originalInfo";
    }

    public String inBox() {
        return "inBox";
    }

    public String list() {
        Archive archive = this.archiveService.getArchive(this.modelName, this.id);
        return "list";
    }

    public String out() {
        if (StringUtils.isNotBlank((String)this.id) && StringUtils.isNotBlank((String)this.modelName)) {
            Struts2Utils.renderXml((String)this.gatewayService.out(this.id, this.modelName), (String[])new String[0]);
        } else if (StringUtils.isNotBlank((String)this.id)) {
            Struts2Utils.renderXml((String)this.gatewayService.out(this.id), (String[])new String[0]);
        }
        return null;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }

    public Map getDocShowFields() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName + "_jn");
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return this.docShowFields;
    }

    public Map getDocFields() {
        if (this.docFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docFields = doc.getInheritfieldsMap();
            }
            catch (ModelNotFoundException modelNotFoundException) {
                // empty catch block
            }
        }
        return this.docFields;
    }

    private String getEntityTemplate(String name) {
        return this.getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return this.modelService.getModel(this.modelName);
    }

    public String getList() {
        Collection models = this.getModels();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Model model : models) {
            if (!"Archive".equals(model.getParentName())) continue;
            map.put(model.getTitle(), model.getName());
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys() {
        Collection models = this.getModels();
        ArrayList<String> keys = new ArrayList<String>();
        for (Model model : models) {
            if (!"Archive".equals(model.getParentName())) continue;
            keys.add(model.getTitle());
        }
        return keys;
    }

    public Collection<Model> getModels() {
        return this.modelService.getModels();
    }
}

