/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DocEntityAction
extends BaseEntityAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    private String archiveId;

    public void prepare() {
        if (StringUtils.isBlank((String)this.id)) {
            this.entity = this.archiveService.newDocument(this.modelName);
            String cid = (String)this.session.get("currentDId");
            Document lastDocument = null;
            if (cid != null) {
                lastDocument = this.archiveService.getDocument(this.modelName, cid);
            }
            if (lastDocument != null) {
                try {
                    PropertyUtils.copyProperties((Object)this.entity, (Object)lastDocument);
                    ((Document)this.entity).setSxh(Integer.valueOf(((Document)this.entity).getSxh() + 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((Document)this.entity).setId(null);
            }
        } else {
            this.entity = this.archiveService.getDocument(this.modelName, this.id);
            if (this.archiveId == null) {
                this.archiveId = ((Document)this.entity).getArchiveId();
            }
        }
        if (this.entity != null && this.archiveId != null) {
            try {
                Archive archive = this.archiveService.getArchive(this.modelName, this.archiveId);
                ((Document)this.entity).setArchive(archive);
                ((Document)this.entity).setQzh(archive.getQzh());
                ((Document)this.entity).setMlh(archive.getMlh());
                ((Document)this.entity).setAjh(archive.getAjh());
            }
            catch (Exception ex) {
                this.logger.debug(ex.toString());
            }
        }
    }

    protected void doSave(Document entity) {
        this.archiveService.saveDocument(entity);
    }

    protected String getJsCallBack() {
        return "onDocumentComplete";
    }

    protected void afterSave() {
        this.session.put("currentDId", ((Document)this.entity).getId());
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }
}

