/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class ArchiveEntityAction
extends BaseEntityAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    private String treeId;
    private AjhRange ajhRange;
    public Integer _ajh;
    public boolean gd;
    private String template;
    private List<String> mlhs;
    private String currentMlh;
    private Integer currentAjh;
    private String mlh;
    private String bgqx;
    private String nd;
    private String cwlx;
    private String lb;
    private String jnmllx;
    private boolean isMakeUp;

    public String getLb() {
        return this.lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    public String getCwlx() {
        return this.cwlx;
    }

    public void setCwlx(String cwlx) {
        this.cwlx = cwlx;
    }

    public String getNd() {
        return this.nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setGd(boolean gd) {
        this.gd = gd;
    }

    public AjhRange getAjhRange() {
        return this.ajhRange;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getBgqx() {
        return this.bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }

    public boolean isMakeUp() {
        return this.isMakeUp;
    }

    public void setMakeUp(boolean makeUp) {
        this.isMakeUp = makeUp;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getCurrentMlh() {
        return ((Archive)this.entity).getMlh();
    }

    public Integer getCurrentAjh() {
        return ((Archive)this.entity).getAjh();
    }

    public void prepare() {
        boolean isCreate = StringUtils.isBlank((String)this.id);
        if (isCreate) {
            String flh;
            this.entity = this.archiveService.newArchive(this.modelName);
            String cid = (String)this.session.get("currentAId");
            Archive lastArchive = null;
            if (cid != null) {
                lastArchive = this.archiveService.getArchive(this.modelName, cid);
            }
            if (lastArchive != null && lastArchive.getModelName().equals(this.modelName)) {
                try {
                    PropertyUtils.copyProperties((Object)this.entity, (Object)lastArchive);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                ((Archive)this.entity).setDh(null);
            } else if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                ((Archive)this.entity).setDwdm(this.getDwdm());
                ((Archive)this.entity).setQzh(this.getQzh());
            }
            if (StringUtils.isBlank((String)((Archive)this.entity).getNd()) && EnvHolder.isEnable((String)"jintan.enable")) {
                ((Archive)this.entity).setNd(String.valueOf(Calendar.getInstance().get(1)));
            }
            ((Archive)this.entity).setId(UUIDHexGenerator.generate());
            if (StringUtils.isNotBlank((String)this.treeId) && StringUtils.isNotBlank((String)(flh = this.resourceService.getResource(this.treeId, new String[0]).getFlh()))) {
                ((Archive)this.entity).setFlh(flh);
            }
        } else {
            this.entity = this.archiveService.getArchive(this.modelName, this.id);
            if (this.entity == null) {
                this.entity = this.archiveService.newArchive(this.modelName);
            }
        }
        if (isCreate && EnvHolder.isEnable((String)"increaseAjh.enable")) {
            if (EnvHolder.isEnable((String)"jintan.enable")) {
                if ("Wsda".equals(this.modelName)) {
                    this.ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, ((Archive)this.entity).getNd());
                } else if ("Jhcw".equals(this.modelName)) {
                    try {
                        if (PropertyUtils.getProperty((Object)this.entity, (String)"cwlx") != null) {
                            String cwlx = PropertyUtils.getProperty((Object)this.entity, (String)"cwlx").toString();
                            this.ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName, true, ((Archive)this.entity).getNd(), cwlx);
                        }
                        this.ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, ((Archive)this.entity).getNd());
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.toString());
                    }
                } else if ("Swda".equals(this.modelName)) {
                    String lb = null;
                    try {
                        lb = PropertyUtils.getProperty((Object)this.entity, (String)"lb").toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.ajhRange = this.ajhRangeService.getAvailableAjhRangeByLb(this.modelName, lb);
                } else if ("Tddj".equals(this.modelName)) {
                    try {
                        this.ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, ((Archive)this.entity).getNd());
                    }
                    catch (Exception ex) {
                        this.ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                    }
                } else {
                    this.ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, ((Archive)this.entity).getNd());
                }
            } else {
                this.ajhRange = this.getAvailableAjhRange();
            }
            ((Archive)this.entity).setMlh(this.ajhRange.getMlh());
            if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                RecordAjhRange recordAjhRange = this.recordAjhRangeService.getAvailable(this.ajhRange.getMlh(), this.modelName, this.getDwdm());
                if (recordAjhRange != null) {
                    ((Archive)this.entity).setAjh(Integer.valueOf(recordAjhRange.getAjh()));
                } else {
                    ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
                }
            } else {
                ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            }
            if (EnvHolder.isEnable((String)"jiangyin.enable") || EnvHolder.isEnable((String)"jintan.enable") && "Wsda".equals(this.modelName)) {
                ((Archive)this.entity).setBgqx(this.ajhRange.getBgqx());
            }
        }
    }

    protected void preSave() {
        AjhRange preAjhRange;
        if (this.ajhRange != null && StringUtils.isNotBlank((String)this.ajhRange.getId()) && ((Archive)this.entity).getAjh() != null && ((Archive)this.entity).getAjh().intValue() == this.ajhRange.getNextValue()) {
            this.ajhRange = this.ajhRangeService.getAjhRange(this.ajhRange.getId());
            this._ajh = this.ajhRange.getNextValue();
            ((Archive)this.entity).setAjh(this._ajh);
        } else if (!EnvHolder.isEnable((String)"notCheckAjh.enable")) {
            ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
            criterions.add(Restrictions.eq((String)"qzh", (Object)((Archive)this.entity).getQzh()));
            criterions.add(Restrictions.eq((String)"mlh", (Object)((Archive)this.entity).getMlh()));
            criterions.add(Restrictions.eq((String)"ajh", (Object)((Archive)this.entity).getAjh()));
            Page page = this.archiveService.searchArchive(this.modelName, criterions, null, 0, 1);
            if (!page.isEmpty() && !((Archive)page.getItem(0)).getId().equals(((Archive)this.entity).getId())) {
                if (!EnvHolder.isEnable((String)"bengbu.enable") && !this.isMakeUp) {
                    throw new RuntimeException("\u6b64\u6848\u5377\u53f7\u5df2\u88ab\u4f7f\u7528");
                }
                if (EnvHolder.isEnable((String)"jintan.enable") && this.isMakeUp) {
                    this.logger.debug("\u6863\u6848\u8865\u5f55\uff0c\u63d2\u5165\u6848\u5377\u53f7");
                    this.makeUpArchive();
                }
            }
        }
        if (StringUtils.isNotBlank((String)this.treeId)) {
            ((Archive)this.entity).setResourceId(this.treeId);
        }
        if (((Archive)this.entity).getAjh() != null && ((Archive)this.entity).getMlh() != null && !EnvHolder.isEnable((String)"notCheckAjh.enable") && (preAjhRange = this.ajhRange != null ? this.ajhRangeService.getAvailableAjhRange(this.modelName, ((Archive)this.entity).getMlh()) : this.ajhRangeService.getAjhRangesForGeneric(this.modelName, ((Archive)this.entity).getMlh())) != null) {
            if (((Archive)this.entity).getAjh() > preAjhRange.getMaxValue()) {
                throw new RuntimeException("\u6848\u5377\u53f7\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6700\u5927\u6848\u5377\u53f7");
            }
            if (((Archive)this.entity).getAjh() < preAjhRange.getMinValue()) {
                throw new RuntimeException("\u6848\u5377\u53f7\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u6700\u5c0f\u6848\u5377\u53f7");
            }
        }
        if (this.gd) {
            if (!EnvHolder.isEnable((String)"notCheckAjh.enable")) {
                this.ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                if (((Archive)this.entity).getAjh() > this.ajhRange.getNextValue()) {
                    throw new RuntimeException("\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6700\u5927\u6848\u5377\u53f7");
                }
            }
            ((Archive)this.entity).setGdsj(new Date());
            ((Archive)this.entity).setState(1);
        }
        if (EnvHolder.isEnable((String)"changzhou.enable") && EnvHolder.isEnable((String)"allowNullDh.enable")) {
            ((Archive)this.entity).setDh(null);
        }
    }

    private void makeUpArchive() {
        try {
            ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
            criterions.add(Restrictions.eq((String)"mlh", (Object)((Archive)this.entity).getMlh()));
            criterions.add(Restrictions.ge((String)"ajh", (Object)((Archive)this.entity).getAjh()));
            ArrayList<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc((String)"ajh"));
            List ajhRanges = this.ajhRangeService.getAjhRangeByModelName(this.modelName);
            for (AjhRange range : ajhRanges) {
                if (!range.getMlh().equalsIgnoreCase(((Archive)this.entity).getMlh())) continue;
                this.ajhRange = range;
                break;
            }
            Page pages = this.archiveService.searchArchive(this.modelName, criterions, orders, 0, this.ajhRange.getMaxValue().intValue());
            for (int i = pages.getTotalCount(); i > 0; --i) {
                Archive archive = (Archive)pages.getItem(i - 1);
                archive.setAjh(Integer.valueOf(archive.getAjh() + 1));
                archive.setDh(null);
                if (archive.getAjh() > this.ajhRange.getMaxValue()) {
                    throw new RuntimeException("\u6863\u6848\u79fb\u52a8\u540e\u5c06\u4f1a\u8d85\u51fa\u76ee\u5f55\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u5148\u6269\u5145\u76ee\u5f55\u53f7\u3010{" + archive.getMlh() + "}\u3011\u5bb9\u91cf");
                }
                this.archiveService.saveArchive(archive);
            }
        }
        catch (Exception ex) {
            this.logger.error("\u6863\u6848\u8865\u5f55\u5f02\u5e38\u3010{}\u3011,\u786e\u8ba4\u76ee\u5f55\u53f7\u3010{}\u3011\u5df2\u914d\u7f6e", (Object)ex.getLocalizedMessage(), (Object)((Archive)this.entity).getMlh());
            throw new RuntimeException("\u6863\u6848\u8865\u5f55\u5f02\u5e38,\u786e\u8ba4\u76ee\u5f55\u53f7\u3010" + ((Archive)this.entity).getMlh() + "\u3011\u5df2\u914d\u7f6e");
        }
    }

    public String bl() throws Exception {
        return this.renderModelTemplate("bl");
    }

    public String render() throws Exception {
        return this.renderModelTemplate(this.template);
    }

    protected void doSave(Archive entity) {
        this.archiveService.saveArchive(entity);
    }

    protected void afterSave() {
        if (!EnvHolder.isEnable((String)"notCheckAjh.enable")) {
            this.updateAjhRange();
        } else if (EnvHolder.isEnable((String)"notCheckAjh.enable")) {
            List dictList = this.dictService.getItems("increaseAjh");
            for (Item item : dictList) {
                if (!item.getName().equalsIgnoreCase(this.modelName)) continue;
                this.updateAjhRange();
                break;
            }
        }
        this.session.put("currentAId", ((Archive)this.entity).getId());
    }

    public void updateAjhRange() {
        String id;
        if (this._ajh != null) {
            this.ajhRange.setCurrentValue(this._ajh.intValue());
            this.ajhRangeService.saveAjhRange(this.ajhRange);
        }
        if (EnvHolder.isEnable((String)"jiangyin.enable") && StringUtils.isNotBlank((String)(id = this.recordAjhRangeService.removeHasUsed(((Archive)this.entity).getMlh(), ((Archive)this.entity).getModelName(), ((Archive)this.entity).getDwdm(), ((Archive)this.entity).getBgqx(), ((Archive)this.entity).getAjh().intValue())))) {
            this.recordAjhRangeService.remove(id);
        }
    }

    private AjhRange getAvailableAjhRange() {
        if (((Archive)this.entity).getMlh() != null) {
            return this.ajhRangeService.getAvailableAjhRange(this.modelName, ((Archive)this.entity).getMlh());
        }
        return this.ajhRangeService.getAvailableAjhRange(this.modelName);
    }

    protected String getSuccessMsg() {
        return this.entity == null ? super.getSuccessMsg() : ((Archive)this.entity).getId();
    }

    protected String getJsCallBack() {
        return "onArchiveComplete";
    }

    private String getQzh() {
        String qzh = "";
        String dwdm = this.getDwdm();
        try {
            List items = this.dictService.getItems("qzhdwdm");
            for (Item item : items) {
                if (!dwdm.equals(item.getName())) continue;
                qzh = item.getValue();
                break;
            }
        }
        catch (Exception ex) {
            this.logger.info("\u672a\u914d\u7f6e[{}]\u5355\u4f4d\u4ee3\u7801\u5168\u5b97\u53f7\u5b57\u5178\u9879", (Object)"qzhdwdm");
        }
        return qzh;
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String reSetAjhRange() {
        try {
            if (StringUtils.isBlank((String)this.nd)) {
                this.nd = String.valueOf(Calendar.getInstance().get(1));
            }
            this.ajhRange = this.ajhRangeService.getAjhRangeByNdBgqx(this.modelName, this.bgqx, this.nd);
            ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
        }
        catch (Exception ex) {
            this.renderJson((Object)ex.getMessage());
        }
        return null;
    }

    public String changeJnmllx() {
        try {
            if (!StringUtils.isBlank((String)this.jnmllx)) {
                this.ajhRange = this.ajhRangeService.getAvaliableAjhRangeByJnmllx(this.modelName, this.jnmllx);
                ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
                this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
            }
        }
        catch (Exception ex) {
            this.renderJson((Object)ex.getMessage());
        }
        return null;
    }

    public String reSetAjh() {
        try {
            this.ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName, this.mlh);
            ((Archive)this.entity).setMlh(this.mlh);
            ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getBgqx()));
        }
        catch (Exception ex) {
            this.renderJson((Object)"\u8be5\u76ee\u5f55\u6848\u5377\u53f7\u5df2\u7528\u5b8c");
        }
        return null;
    }

    public String reSetMlh() {
        try {
            this.ajhRange = this.ajhRangeService.getAjhRangesByBgqx(this.modelName, this.bgqx);
            RecordAjhRange recordAjhRange = this.recordAjhRangeService.getRecordAjhRange(this.ajhRange.getMlh(), this.modelName, this.getDwdm(), this.bgqx);
            ((Archive)this.entity).setMlh(this.ajhRange.getMlh());
            int tempAjh = this.ajhRange.getNextValue();
            if (recordAjhRange != null) {
                ((Archive)this.entity).setAjh(Integer.valueOf(recordAjhRange.getAjh()));
                tempAjh = recordAjhRange.getAjh();
            } else {
                ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            }
            this.renderJson((Object)(tempAjh + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
        }
        catch (Exception ex) {
            this.renderJson((Object)ex.getMessage());
        }
        return null;
    }

    public String changeNd() {
        if (StringUtils.isBlank((String)this.nd)) {
            this.nd = String.valueOf(Calendar.getInstance().get(1));
        }
        if (EnvHolder.isEnable((String)"jintan.enable")) {
            if ("Wsda".equals(this.modelName)) {
                this.ajhRange = this.ajhRangeService.getAjhRangeByNdBgqx(this.modelName, ((Archive)this.entity).getBgqx(), this.nd);
                ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            } else if ("Jhcw".equals(this.modelName)) {
                this.ajhRange = "\u51ed\u8bc1".equals(this.cwlx) ? this.ajhRangeService.getAvailableAjhRange(this.modelName, true, this.nd, this.cwlx) : this.ajhRangeService.getAvailableAjhRange(this.modelName, false, this.nd, this.cwlx);
            } else if (!"Swda".equals(this.modelName)) {
                this.ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, this.nd);
            }
        } else {
            this.ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, this.nd);
        }
        this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
        return null;
    }

    public String changeCwlx() {
        if (StringUtils.isBlank((String)this.cwlx)) {
            return null;
        }
        this.ajhRange = "\u51ed\u8bc1".equals(this.cwlx) ? this.ajhRangeService.getAvailableAjhRange(this.modelName, true, ((Archive)this.entity).getNd(), this.cwlx) : this.ajhRangeService.getAvailableAjhRange(this.modelName, true, null, this.cwlx);
        this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
        return null;
    }

    public String changeLb() {
        if (StringUtils.isBlank((String)this.lb)) {
            return null;
        }
        this.ajhRange = this.ajhRangeService.getAvailableAjhRangeByLb(this.modelName, this.lb);
        this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
        return null;
    }

    public String getAvailableAjh() {
        AjhRange ajhRange1 = null;
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            ajhRange1 = this.mlh != null ? this.ajhRangeService.getAvailableAjhRange(this.modelName, this.mlh) : this.ajhRangeService.getAvailableAjhRange(this.modelName);
            info.put("success", ajhRange1);
            this.renderJson(info);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            info.put("error", ex.getMessage());
            this.renderJson(info);
        }
        return null;
    }

    public String getMlh() {
        return this.mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public List<String> getMlhs() {
        if (this.template == null) {
            return this.ajhRangeService.getMlhByModelName(this.modelName);
        }
        return this.ajhRangeService.getMlh(this.modelName, ((Archive)this.entity).getDwdm());
    }

    public String getJnmllx() {
        return this.jnmllx;
    }

    public void setJnmllx(String jnmllx) {
        this.jnmllx = jnmllx;
    }
}

