/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class ArchiveAction
extends BaseModelAction<Archive> {
    private static final Object Lock = 1;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    private SysUserService userService;
    private String treeId;
    private String type;
    private List<Item> operations;
    private Map<String, String> topMenu;
    private String mlh;
    private Integer ajh;
    private Integer endAjh;
    private Integer boxSize;
    private Map docShowFields;
    private Map docFields;
    private String linkField;
    private String docLinkField;
    private String wgdState = "false";
    private File upload;
    private String uploadFileName;
    private Map<String, String> queryParam = new HashMap();
    private Map<String, String> receivedParam = new HashMap();
    private List<Map<String, Object>> tree;
    private List docEntities;

    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName((String)modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return this.boxSize;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getType() {
        return this.type;
    }

    public List<Item> getOperations() {
        return this.operations;
    }

    public String getWgdState() {
        return this.wgdState;
    }

    public void setWgdState(String wgdState) {
        this.wgdState = wgdState;
    }

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public Map<String, String> getQueryParam() {
        if (EnvHolder.isEnable((String)"sjws.enable")) {
            try {
                return (Map)JSON.parseObject((String)this.getEntityTemplate("queryParam"), LinkedHashMap.class);
            }
            catch (Exception ex) {
                return new HashMap<String, String>();
            }
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> getReceivedParam() {
        if (EnvHolder.isEnable((String)"sjws.enable")) {
            try {
                return (Map)JSON.parseObject((String)this.getEntityTemplate("receivedParam"), LinkedHashMap.class);
            }
            catch (Exception ex) {
                return new HashMap<String, String>();
            }
        }
        return new HashMap<String, String>();
    }

    public String getTddjPath() {
        return EnvHolder.getAppEnv().get((Object)"tddj.path");
    }

    public static Object getLock() {
        return Lock;
    }

    public String getPermJson() {
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : this.operations) {
            if (!this.securityService.isPermitted(this.treeId, item.getName())) continue;
            perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : this.operations) {
            if (!this.securityService.isPermitted(this.treeId, item.getName())) continue;
            perm.put(item.getName(), true);
        }
        return perm;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString((Object)this.rewrite(this.treeService.getTree(this.treeId)));
    }

    public List<Map<String, Object>> getTree() {
        if (this.tree == null) {
            List listTree = this.treeService.getTree(null, new String[]{"model"});
            for (Map item : listTree) {
                this.logger.debug(item.toString());
                if (!item.get("name").equals("generic")) continue;
                listTree.remove(item);
                break;
            }
            this.tree = listTree;
        }
        return this.tree;
    }

    public Map<String, String> getTopMenu() {
        if (this.topMenu == null) {
            this.topMenu = new LinkedHashMap();
            for (Item item : this.dictService.getItems("archiveMenu")) {
                if (!"true".equalsIgnoreCase(item.getValue())) continue;
                this.topMenu.put(item.getName(), item.getRemark());
            }
        }
        if (EnvHolder.isEnable((String)"importExcel.enable")) {
            ArrayList<String> menuList = new ArrayList<String>();
            for (Item item : this.dictService.getItems("importMenu")) {
                menuList.add(item.getName());
            }
            if (!menuList.contains(this.modelName)) {
                this.topMenu.remove("importExcel");
            }
        } else {
            this.topMenu.remove("importExcel");
        }
        return this.topMenu;
    }

    public String execute() {
        Archive archive;
        this.operations = this.dictService.getItems("operationPerm");
        if (StringUtils.isNotEmpty((String)this.modelName)) {
            Resource res = this.resourceService.findChildResource(null, this.modelName, new String[]{"model"});
            if (res != null) {
                this.treeId = res.getId();
                if (!this.securityService.isPermitted(this.treeId, "view")) {
                    throw new NoPermissionException(this.modelName);
                }
            } else {
                throw new ModelNotFoundException(this.modelName);
            }
        }
        this.modelService.getModel(this.modelName);
        String id = this.getId();
        if (id != null && (archive = this.archiveService.getArchive(this.modelName, id)) != null) {
            String string = this.type = archive.getState() == 1 ? "ygd" : "wgd";
        }
        if (EnvHolder.isEnable((String)"wgdyw.enable")) {
            List dictList = this.dictService.getItems("wgdyw");
            for (Item item : dictList) {
                if (!item.getName().equalsIgnoreCase(this.modelName)) continue;
                this.setWgdState("true");
                break;
            }
        }
        return "success";
    }

    public String gd() {
        for (String id : this.ids) {
            if (StringUtils.isBlank((String)id)) continue;
            Archive archive = this.archiveService.getArchive(this.modelName, id);
            AjhRange ajhRange = null;
            if (archive.getDh() == null && !EnvHolder.isEnable((String)"notNeedAjh.enable")) {
                try {
                    if (PropertyUtils.isReadable((Object)archive, (String)"jnmllx")) {
                        ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName, archive);
                    } else if (!EnvHolder.isEnable((String)"jintan.enable")) {
                        ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                    } else if ("Tddj".equalsIgnoreCase(this.modelName) && this.getDwdm().length() == 6 && archive.getNd() != null) {
                        try {
                            ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, archive.getNd());
                        }
                        catch (Exception ex) {
                            ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                        }
                    } else {
                        ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                    }
                }
                catch (EntityNotFoundException e) {
                    Struts2Utils.renderText((String)e.getMessage(), (String[])new String[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (!EnvHolder.isEnable((String)"notCheckAjh.enable")) {
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(Integer.valueOf(ajhRange.getNextValue()));
                } else if (EnvHolder.isEnable((String)"notCheckAjh.enable")) {
                    List dictList = this.dictService.getItems("increaseAjh");
                    boolean flag = false;
                    for (Item item : dictList) {
                        if (item.getName().equalsIgnoreCase(this.modelName)) {
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(Integer.valueOf(ajhRange.getCurrentValue()));
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        archive.setMlh(ajhRange.getMlh());
                        archive.setAjh(Integer.valueOf(ajhRange.getNextValue()));
                    }
                }
            }
            archive.setState(1);
            archive.setGdsj(new Date());
            this.archiveService.saveArchive(archive);
            try {
                List documents = this.archiveService.getArchiveDocuments(this.modelName + "_jn", archive.getId());
                for (Document document : documents) {
                    document.setMlh(archive.getMlh());
                    document.setAjh(archive.getAjh());
                    this.archiveService.saveDocument(document);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (ajhRange == null) continue;
            ajhRange.setCurrentValue(archive.getAjh().intValue());
            this.ajhRangeService.saveAjhRange(ajhRange);
        }
        return null;
    }

    public String cxgd() {
        for (String id : this.ids) {
            if (StringUtils.isBlank((String)id)) continue;
            Archive archive = this.archiveService.getArchive(this.modelName, id);
            archive.setState(0);
            archive.setGdsj(null);
            if (EnvHolder.isEnable((String)"allowNullDh.enable")) {
                archive.setMlh(null);
                archive.setAjh(null);
                archive.setDh(null);
            }
            this.archiveService.saveArchive(archive);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fastGd() throws Exception {
        Object object = Lock;
        synchronized (object) {
            String id = this.getId();
            if (StringUtils.isNotBlank((String)id)) {
                Archive archive = this.archiveService.getArchive(this.modelName, id);
                archive.setState(1);
                archive.setGdsj(new Date());
                AjhRange ajhRange = null;
                if (archive.getDh() == null) {
                    if (!EnvHolder.isEnable((String)"jintan.enable")) {
                        ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                    } else if ("Tddj".equalsIgnoreCase(this.modelName) && this.getDwdm().length() == 6 && archive.getNd() != null) {
                        try {
                            ajhRange = this.ajhRangeService.getAvailableAjhRangByNd(this.modelName, archive.getNd());
                        }
                        catch (Exception ex) {
                            ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                        }
                    } else {
                        ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                    }
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(Integer.valueOf(ajhRange.getNextValue()));
                }
                this.archiveService.saveArchive(archive);
                if (ajhRange != null) {
                    ajhRange.setCurrentValue(archive.getAjh().intValue());
                    this.ajhRangeService.saveAjhRange(ajhRange);
                }
            }
        }
        return this.renderModelTemplate("fastGd");
    }

    public String move() {
        if (StringUtils.isBlank((String)this.treeId)) {
            this.treeId = null;
        }
        for (String id : this.ids) {
            if (StringUtils.isBlank((String)id)) continue;
            Archive archive = this.archiveService.getArchive(this.modelName, id);
            archive.setResourceId(this.treeId);
            this.archiveService.saveArchive(archive);
        }
        return null;
    }

    public String order() {
        AjhRange ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
        for (Archive archive : this.getEntities()) {
            if (!ajhRange.hasExhausted()) {
                this.ajhRangeService.saveAjhRange(ajhRange);
                ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
            }
            archive.setAjh(Integer.valueOf(ajhRange.getNextValue()));
            archive.setDh(null);
            this.archiveService.saveArchive(archive);
        }
        return null;
    }

    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (EnvHolder.isEnable((String)"jiangyin.enable")) {
            Page page = this.archiveService.searchArchive(this.modelName, criterions, orders, this.start, this.limit);
            for (Archive archive : page.getItems()) {
                archive.setHasOriginal(Boolean.valueOf(this.originalService.hasOriginal(archive.getId())));
            }
            return page;
        }
        return this.archiveService.searchArchive(this.modelName, criterions, orders, this.start, this.limit);
    }

    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (this.ajh != null) {
            criterions.add((Criterion)Restrictions.eq((String)"mlh", (Object)this.mlh));
            criterions.add((Criterion)Restrictions.gt((String)"ajh", (Object)(this.ajh - 1)));
            if (this.endAjh != null) {
                criterions.add((Criterion)Restrictions.lt((String)"ajh", (Object)(this.endAjh + 1)));
            }
            this.sort = "ajh";
        } else {
            if (this.type == null || !this.type.equals("all")) {
                criterions.add((Criterion)Restrictions.eq((String)"state", (Object)("ygd".equals(this.type) ? 1 : 0)));
            }
            if (StringUtils.isNotBlank((String)this.treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get((Object)"classifyViewMode"))) {
                    String[] treeIds = this.treeId.split(",");
                    if (treeIds.length == 1) {
                        if (this.resourceService.getResource(this.treeId, new String[0]).getName().equals(this.modelName)) {
                            criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId), (Criterion)Restrictions.isNull((String)"resourceId")));
                        } else {
                            criterions.add((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId));
                        }
                    } else if (treeIds.length > 2) {
                        LogicalExpression temp = Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[0]), (Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[1]));
                        for (int i = 2; i < treeIds.length; ++i) {
                            temp = Restrictions.or((Criterion)temp, (Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[i]));
                        }
                        criterions.add((Criterion)temp);
                    } else {
                        criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[0]), (Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[1])));
                    }
                } else if (this.resourceService.getResource(this.treeId, new String[0]).getName().equals(this.modelName)) {
                    criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId), (Criterion)Restrictions.isNull((String)"resourceId")));
                } else {
                    criterions.add((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId));
                }
            } else {
                criterions.add(Restrictions.isNull((String)"resourceId"));
            }
        }
        return super.createCriterions(criterions);
    }

    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                this.rewrite((List)map.get("children"));
                String id = (String)map.get("id");
                HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
                for (Item item : this.operations) {
                    if (!this.securityService.isPermitted(id, item.getName())) continue;
                    perm.put(item.getName(), true);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    public Map getDocShowFields() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return this.docShowFields;
    }

    public Map getDocFields() {
        if (this.docFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docFields = doc.getInheritfieldsMap();
            }
            catch (ModelNotFoundException modelNotFoundException) {
                // empty catch block
            }
        }
        return this.docFields;
    }

    public String getLinkField() {
        if (this.linkField == null) {
            try {
                this.linkField = this.archiveService.getArchiveModel(this.modelName).getTemplate("linkField");
            }
            catch (Exception ex) {
                this.linkField = "tm";
            }
        }
        return this.linkField;
    }

    public String getDocLinkField() {
        if (this.docLinkField == null) {
            try {
                this.docLinkField = this.archiveService.getDocumentModel(this.modelName).getTemplate("linkField");
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docLinkField = "tm";
            }
        }
        return this.docLinkField;
    }

    public String fastAddOG() throws Exception {
        return this.renderModelTemplate("fastAddOG");
    }

    public boolean getIsShowArchiveInfo() {
        try {
            if (this.modelService.getModel(this.modelName.concat("_ai")) != null) {
                return true;
            }
        }
        catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    public boolean getIsShowArchiveDoc() {
        try {
            if (this.modelService.getModel(this.modelName.concat("_jn")) != null) {
                return true;
            }
        }
        catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    public String printArcDocs() throws IOException, TemplateException {
        try {
            return this.renderTemplate(this.getEntityModel().getTemplate("printArcDoc"));
        }
        catch (TemplateNotFoundException ex) {
            this.logger.error(ex.getMessage());
            return null;
        }
    }

    public String gdAfterSearch() {
        List list = this.getEntityPage().getItems();
        for (Archive archive : list) {
            AjhRange ajhRange = null;
            if (archive.getDh() == null) {
                try {
                    ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
                }
                catch (EntityNotFoundException e) {
                    Struts2Utils.renderText((String)e.getMessage(), (String[])new String[0]);
                }
                archive.setMlh(ajhRange.getMlh());
                archive.setAjh(Integer.valueOf(ajhRange.getNextValue()));
            }
            archive.setState(1);
            archive.setGdsj(new Date());
            this.archiveService.saveArchive(archive);
            if (ajhRange == null) continue;
            ajhRange.setCurrentValue(archive.getAjh().intValue());
            this.ajhRangeService.saveAjhRange(ajhRange);
        }
        return null;
    }

    public String remove() throws Exception {
        if (EnvHolder.isEnable((String)"jiangyin.enable")) {
            for (String id : this.ids) {
                Archive archive = this.archiveService.getArchive(this.modelName, id);
                RecordAjhRange recordAjhRange = new RecordAjhRange();
                recordAjhRange.setAjh(archive.getAjh().intValue());
                recordAjhRange.setMlh(archive.getMlh());
                recordAjhRange.setDwdm(archive.getDwdm());
                recordAjhRange.setModelName(archive.getModelName());
                recordAjhRange.setBgqx(archive.getBgqx());
                this.recordAjhRangeService.saveRecordAjh(recordAjhRange);
            }
        }
        super.remove();
        return null;
    }

    public List getDocEntities() {
        if (this.docEntities != null) {
            return this.docEntities;
        }
        this.docEntities = new ArrayList();
        if (this.ids.length > 0) {
            for (String id : this.ids) {
                this.docEntities.addAll(this.archiveService.getArchiveDocuments(this.modelName, id));
            }
        }
        return this.docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank((String)idString)) {
            this.ids = idString.split(",");
        }
    }

    public String searchIds() {
        List criterions = this.createCriterions(new ArrayList());
        List orders = this.createOrders(new ArrayList());
        List items = this.entityService.search(this.modelName, criterions, orders, this.start, this.limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), (String)"id") + ",");
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.toString());
            }
        }
        this.ids = sb.toString().split(",");
        return this.cacheIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importExcel() {
        String realpath = ServletActionContext.getServletContext().getRealPath("/WEB-INF");
        String msg = "";
        if (this.upload != null) {
            File savefile = new File(new File(realpath), this.uploadFileName);
            try {
                FileUtils.copyFile((File)this.upload, (File)savefile);
                FileInputStream is = new FileInputStream(realpath + File.separator + this.uploadFileName);
                HSSFWorkbook hssfWorkbook = new HSSFWorkbook((InputStream)is);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                    HSSFSheet hSSFSheet = hssfWorkbook.getSheetAt(numSheet);
                    if (hSSFSheet == null) continue;
                    HashMap<Integer, String> filedMap = new HashMap<Integer, String>();
                    HSSFRow hssfRowTitle = hSSFSheet.getRow(1);
                    for (int titleNum = 0; titleNum < hssfRowTitle.getLastCellNum(); ++titleNum) {
                        for (Field field : this.modelService.getModel(this.modelName).getInheritfieldsMap().values()) {
                            if (hssfRowTitle.getCell(titleNum) == null || !hssfRowTitle.getCell(titleNum).toString().replaceAll(" ", "").equals(field.getTitle())) continue;
                            filedMap.put(titleNum, field.getName());
                        }
                    }
                    for (int rowNum = 2; rowNum <= hSSFSheet.getLastRowNum(); ++rowNum) {
                        Object o = this.entityService.newInstance(this.modelName);
                        HSSFRow hssfRow = hSSFSheet.getRow(rowNum);
                        if (hssfRow == null) continue;
                        for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                            if (filedMap.get(cellNum) == null || hssfRow.getCell(cellNum) == null) continue;
                            if (PropertyUtils.getPropertyType((Object)o, (String)filedMap.get(cellNum).toString()) == String.class) {
                                if (hssfRow.getCell(cellNum) == null || "".equals(hssfRow.getCell(cellNum).toString())) {
                                    PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), null);
                                    continue;
                                }
                                if ("nd".equals(filedMap.get(cellNum).toString())) {
                                    PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)hssfRow.getCell(cellNum).toString().substring(0, hssfRow.getCell(cellNum).toString().lastIndexOf(".")));
                                    continue;
                                }
                                PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)hssfRow.getCell(cellNum).toString());
                                continue;
                            }
                            if (PropertyUtils.getPropertyType((Object)o, (String)filedMap.get(cellNum).toString()) == Boolean.class) {
                                PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)hssfRow.getCell(cellNum).getBooleanCellValue());
                                continue;
                            }
                            if (PropertyUtils.getPropertyType((Object)o, (String)filedMap.get(cellNum).toString()) == Integer.class) {
                                if (hssfRow.getCell(cellNum) == null || "".equals(hssfRow.getCell(cellNum).toString())) {
                                    PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)0);
                                    continue;
                                }
                                PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)Math.round(Float.valueOf(hssfRow.getCell(cellNum).toString()).floatValue()));
                                continue;
                            }
                            if (PropertyUtils.getPropertyType((Object)o, (String)filedMap.get(cellNum).toString()) == Float.class) {
                                if (hssfRow.getCell(cellNum) == null || "".equals(hssfRow.getCell(cellNum).toString())) {
                                    PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)0);
                                    continue;
                                }
                                PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)Float.valueOf(hssfRow.getCell(cellNum).toString()));
                                continue;
                            }
                            if (hssfRow.getCell(cellNum) == null || PropertyUtils.getPropertyType((Object)o, (String)filedMap.get(cellNum).toString()) == Double.class) {
                                if ("".equals(hssfRow.getCell(cellNum).toString())) {
                                    PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)0);
                                    continue;
                                }
                                PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)Double.valueOf(hssfRow.getCell(cellNum).toString()));
                                continue;
                            }
                            if (PropertyUtils.getPropertyType((Object)o, (String)filedMap.get(cellNum).toString()) != Date.class) continue;
                            PropertyUtils.setProperty((Object)o, (String)filedMap.get(cellNum).toString(), (Object)hssfRow.getCell(cellNum).getDateCellValue());
                        }
                        PropertyUtils.setProperty((Object)o, (String)"id", (Object)UUIDHexGenerator.generate());
                        if (PropertyUtils.getProperty((Object)o, (String)"dh") == null || PropertyUtils.getProperty((Object)o, (String)"dh") == "") continue;
                        list.add(o);
                    }
                }
                for (Object e : list) {
                    this.entityService.save(e);
                }
                msg = "\u5bfc\u5165\u6210\u529f";
            }
            catch (IOException e) {
                e.printStackTrace();
                msg = "\u5bfc\u5165\u5931\u8d25";
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                msg = "\u5bfc\u5165\u5931\u8d25";
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                msg = "\u5bfc\u5165\u5931\u8d25";
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                msg = "\u5bfc\u5165\u5931\u8d25";
            }
            catch (Exception e) {
                e.printStackTrace();
                msg = "\u5bfc\u5165\u5931\u8d25";
            }
            finally {
                if (savefile.exists()) {
                    savefile.delete();
                }
            }
        }
        this.renderJson((Object)msg);
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        }
        return dwdm;
    }
}

