/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.LoanService;
import com.gtis.common.Page;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoanServiceImpl
implements LoanService<LoanCart> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EntityService entityService;

    public void addToCart(LoanCart entity) {
        this.entityService.save((Object)entity);
    }

    public void removeFromCart(LoanCart entity) {
        this.entityService.remove(LoanCart.class, new String[]{entity.getId()});
    }

    public void removeFromeCart(String[] ids) {
        this.entityService.remove(LoanCart.class, ids);
    }

    public void doLoan(Loan[] entities) {
        throw new RuntimeException("\u5f03\u7528\u8be5\u65b9\u6cd5\uff0c\u7528\u53e6\u4e00\u4e2a\u540c\u540d\u65b9\u6cd5");
    }

    public void doLoan(List<LoanCart> loanCarts, Loan loan) {
        ArrayList<Loan> loans = new ArrayList<Loan>();
        for (LoanCart loanCart : loanCarts) {
            try {
                Loan loan1 = loan.clone();
                loan1.setArchiveId(loanCart.getArchiveId());
                loan1.setState(0);
                loans.add(loan1);
                this.removeFromCart(loanCart);
            }
            catch (CloneNotSupportedException e) {
                this.logger.error("\u501f\u9605\u6570\u636e\u62f7\u8d1d\u5f02\u5e38", (Object)e.getLocalizedMessage());
            }
        }
        if (loans.size() != loanCarts.size()) {
            return;
        }
        for (Loan loan1 : loans) {
            this.entityService.save((Object)loan1);
        }
    }

    public Page<LoanCart> getPages(int start, int limit, List<? extends Criterion> criterions) {
        return this.entityService.search(LoanCart.class.getSimpleName(), criterions, null, start, limit);
    }

    public int count(List<? extends Criterion> criterions) {
        return this.entityService.getCount(LoanCart.class, criterions);
    }
}

