/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.gtis.archive.entity.Archive;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="t_document")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Document {
    public static final String MODEL_NAME = Document.class.getSimpleName();
    @Id
    @GeneratedValue(generator="sort-uuid")
    @GenericGenerator(name="sort-uuid", strategy="com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length=32)
    private String id;
    @Column(length=10)
    private String modelName = this.getClass().getSimpleName();
    @Column(length=100)
    private String tm;
    @Column(length=100, nullable=true)
    private String qzh;
    @Column(length=100)
    private String mlh;
    @Column
    private Integer ajh;
    @Column
    private Integer sxh;
    @Column(length=100)
    private String yh;
    @Column(length=100)
    private String wh;
    @Column(length=100)
    private String zrz;
    private Date rq;
    @Column(length=100)
    private String bz;
    @Column(length=32)
    private String archiveId;
    @Column(length=100)
    private String dwdm;
    @Transient
    private Boolean hasOriginal;
    @Transient
    private Archive archive;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty((String)modelName)) {
            this.modelName = modelName;
        }
    }

    public String getTm() {
        return this.tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public Integer getSxh() {
        return this.sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    public String getYh() {
        return this.yh;
    }

    public void setYh(String yh) {
        this.yh = yh;
    }

    public String getWh() {
        return this.wh;
    }

    public void setWh(String wh) {
        this.wh = wh;
    }

    public String getZrz() {
        return this.zrz;
    }

    public void setZrz(String zrz) {
        this.zrz = zrz;
    }

    @JSONField(format="yyyy-MM-dd")
    public Date getRq() {
        return this.rq;
    }

    public void setRq(Date rq) {
        this.rq = rq;
    }

    public String getBz() {
        return this.bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = StringUtils.isBlank((String)archiveId) ? null : archiveId;
    }

    public String getDwdm() {
        return this.dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public Boolean getHasOriginal() {
        return this.hasOriginal;
    }

    public void setHasOriginal(Boolean hasOriginal) {
        this.hasOriginal = hasOriginal;
    }

    public static boolean isDocumentModelName(String modelName) {
        return modelName.endsWith("_jn") || MODEL_NAME.equals(modelName);
    }

    public static String toArchiveModelName(String docModelName) {
        int index = docModelName.indexOf("_jn");
        if (index > 0) {
            return docModelName.substring(0, index);
        }
        if (MODEL_NAME.equals(docModelName)) {
            return Archive.MODEL_NAME;
        }
        return docModelName;
    }

    public String getQzh() {
        return this.qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getMlh() {
        return this.mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public Integer getAjh() {
        return this.ajh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }
}

