/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.web;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.LRUMap;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.freemarker.FreemarkerManager;

public class FreemarkerRenderSupport {
    private static final Map<String, Template> tplCaches = Collections.synchronizedMap(new LRUMap(500));
    private Configuration configuration;
    private FreemarkerManager freemarkerManager;

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) throws TemplateException {
        this.freemarkerManager = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String renderTemplate(String content) throws TemplateException, IOException {
        this.configuration = this.freemarkerManager.getConfiguration(ServletActionContext.getServletContext());
        TemplateModel model = this.createModel();
        Template template = (Template)tplCaches.get(content);
        if (template == null) {
            template = new Template(null, (Reader)new StringReader(content), this.configuration);
            tplCaches.put(content, template);
        }
        if (this.preTemplateProcess(template, model)) {
            try {
                HttpServletResponse response = ServletActionContext.getResponse();
                response.setContentType("text/html;charset=UTF-8");
                template.process((Object)model, (Writer)response.getWriter());
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
        return null;
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        return true;
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ValueStack stack = ServletActionContext.getContext().getValueStack();
        return this.freemarkerManager.buildTemplateModel(stack, (Object)this, servletContext, request, response, this.configuration.getObjectWrapper());
    }
}

