/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.EntityParameterException;
import com.gtis.archive.core.support.freemarker.DictModel;
import com.gtis.archive.core.web.BaseAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.SessionAware;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseEntityAction<T>
extends BaseAction
implements ModelDriven<T>,
Preparable,
SessionAware {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected DictService dictService;
    @Autowired
    protected AjhRangeService ajhRangeService;
    protected String modelName;
    protected String id;
    protected T entity;
    protected Map<String, Object> session;

    public BaseEntityAction() {
        Type params;
        Type genType = this.getClass().getGenericSuperclass();
        if (genType instanceof ParameterizedType && (params = ((ParameterizedType)genType).getActualTypeArguments()[0]) instanceof Class) {
            this.setModelName(((Class)params).getSimpleName());
        }
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Model getEntityModel() {
        return this.modelService.getModel(this.modelName);
    }

    public Map<String, Field> getFields() {
        return this.getEntityModel().getInheritfieldsMap();
    }

    public DictModel get_dict() {
        return new DictModel(this.dictService);
    }

    public T getModel() {
        if (this.entity == null) {
            this.prepare();
        }
        return (T)this.entity;
    }

    public List get_mlhs() {
        ArrayList<String> mlhs = new ArrayList<String>();
        List ajhRanges = this.ajhRangeService.getAjhRangeByModelName(this.modelName);
        for (AjhRange ajhRange : ajhRanges) {
            mlhs.add(ajhRange.getMlh());
        }
        return mlhs;
    }

    public void prepare() {
        this.entity = StringUtils.isBlank((String)this.id) ? this.entityService.newInstance(this.modelName) : this.entityService.load(this.modelName, this.id);
    }

    public String execute() throws Exception {
        return this.renderModelTemplate("edit");
    }

    public String input() throws Exception {
        throw new EntityParameterException(this.getModel().getClass());
    }

    public String preview() throws Exception {
        return this.renderModelTemplate("preview");
    }

    public String save() throws Exception {
        return this.renderJs((BaseAction.Runner)new /* Unavailable Anonymous Inner Class!! */, this.getSuccessMsg(), null, this.getJsCallBack());
    }

    protected void preSave() {
    }

    protected void afterSave() {
    }

    protected void doSave(T entity) {
        this.entityService.save(entity);
    }

    protected String getSuccessMsg() {
        return "\u4fdd\u5b58\u6210\u529f";
    }

    protected String getJsCallBack() {
        return null;
    }

    protected String getEntityTemplate(String name) {
        return this.getEntityModel().getTemplate(name);
    }

    protected String renderModelTemplate(String name) throws Exception {
        return this.renderTemplate(this.getEntityTemplate(name));
    }
}

