/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.util.CriteriaCallback;
import com.gtis.common.Page;
import com.gtis.support.hibernate.HibernateDao;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityServiceImpl
extends HibernateDao
implements EntityService {
    private static final Logger logger = LoggerFactory.getLogger(EntityServiceImpl.class);
    private ModelService modelService;

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public void cleanCache() {
        SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true).clear();
    }

    public String getModelName(Object entity) {
        return this.modelService.getModelName(entity);
    }

    public Model getModel(String modelName) {
        return this.modelService.getModel(modelName);
    }

    public <T> T load(String modelName, String id) {
        return (T)this.load(this.getModelClass(modelName), id);
    }

    @Transactional
    public <T> T load(Class clazz, String id) {
        List t = this.find("from\t" + clazz.getName() + "\t" + " c where c.id=?", new Object[]{id});
        return t.size() == 0 ? null : (T)t.get(0);
    }

    public <T> T newInstance(String modelName) {
        return (T)this.newInstance(this.getModelClass(modelName));
    }

    public <T> T newInstance(Class clazz) {
        try {
            Object obj = clazz.newInstance();
            this.processDefaultValue(obj);
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("model:[" + clazz.getName() + "] instance error.");
        }
    }

    @Transactional
    public void remove(String modelName, String[] ids) {
        this.remove(this.getModelClass(modelName), ids);
    }

    @Transactional
    public void remove(Class clazz, String[] ids) {
        try {
            for (String id : ids) {
                this.getSession().delete(this.load(clazz, id));
            }
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            ex.printStackTrace();
        }
    }

    public <T> T query(String modelName, Criterion ... criterions) {
        return (T)this.query(this.getModelClass(modelName), criterions);
    }

    public <T> T query(Class clazz, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(clazz);
        if (criterions != null) {
            for (Criterion c : criterions) {
                if (c == null) continue;
                criteria.add(c);
            }
        }
        return (T)criteria.uniqueResult();
    }

    @Transactional
    public <T> T save(Object entity) {
        this.processDefaultValue(entity);
        this.getSession().saveOrUpdate(entity);
        return (T)entity;
    }

    public <X> Page<X> search(CriteriaCallback callback, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        Criteria criteria = callback.create(this.getSession());
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        if (orders != null) {
            for (Order order : orders) {
                if (order == null) continue;
                criteria.addOrder(order);
            }
        }
        return this.search(criteria, start, limit);
    }

    public <T> Page<T> search(CriteriaCallback callback, int start, int limit) {
        return this.search(callback, null, null, start, limit);
    }

    public <T> Page<T> search(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        return this.search(this.getModelClass(modelName), criterions, orders, start, limit);
    }

    public <T> T query(String hql, Object ... values) {
        return (T)this.findUnique(hql, values);
    }

    public <T> T query(String hql, Map<String, ?> values) {
        return (T)this.findUnique(hql, values);
    }

    public <T> Page<T> search(String hql, String countHql, int start, int limit, Object ... values) {
        return this.doSearch(hql, countHql, start, limit, (Object)values);
    }

    public <T> Page<T> search(String hql, String countHql, int start, int limit, Map<String, ?> values) {
        return this.doSearch(hql, countHql, start, limit, values);
    }

    public <T> Page<T> search(String hql, int start, int limit, Object ... values) {
        return this.search(hql, "select count(*) " + hql, start, limit, values);
    }

    public <T> Page<T> search(String hql, int start, int limit, Map<String, ?> values) {
        return this.search(hql, "select count(*) " + hql, start, limit, values);
    }

    private <T> Page<T> doSearch(String hql, String countHql, int start, int limit, Object values) {
        Page page = new Page(Page.toIndex((int)start, (int)limit), limit);
        if (countHql == null || limit == -1) {
            Query query = this.createQuery(hql, new Object[]{values});
            page.setItems(query.list());
        } else {
            Query query = this.createQuery(countHql, new Object[]{values});
            int totalCount = EntityServiceImpl.toInt((Long)((Long)query.uniqueResult()), (int)0);
            page.setTotalCount(totalCount);
            if (totalCount > 0) {
                query = this.createQuery(hql, new Object[]{values}).setFirstResult(start).setMaxResults(limit);
                page.setItems(query.list());
            }
        }
        return page;
    }

    public int getCount(String modelName, List<? extends Criterion> criterions) {
        return this.getCount(this.getModelClass(modelName), criterions);
    }

    public int getCount(Class clazz, List<? extends Criterion> criterions) {
        try {
            Criteria criteria = this.getSession().createCriteria(clazz);
            if (criterions != null) {
                for (Criterion criterion : criterions) {
                    criteria.add(criterion);
                }
            }
            return EntityServiceImpl.toInt((Long)((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()), (int)0);
        }
        catch (Exception e) {
            logger.error("getCount for model" + clazz + " error", (Throwable)e);
            return 0;
        }
    }

    private Class getModelClass(String modelName) {
        try {
            return this.modelService.getClass(modelName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("model:[" + modelName + "] not found.");
        }
    }

    private void processDefaultValue(Object entity) {
        Model model = this.modelService.getModel(entity);
        Environment env = new Environment(entity, model.getEnv());
        for (Field field : model.getInheritfieldsMap().values()) {
            String prop = field.getName();
            try {
                String defaultValue;
                Object v = PropertyUtils.getSimpleProperty((Object)entity, (String)prop);
                if (v != null && !"".equals(v) && !"0".equals(v.toString()) || field.getDefaultValue() == null || (defaultValue = env.getExpr(field.getDefaultValue())) == null) continue;
                if (field.getType() == Field.Type.DATE) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = sdf.parse(defaultValue);
                    BeanUtils.setProperty((Object)entity, (String)prop, (Object)date);
                    continue;
                }
                BeanUtils.setProperty((Object)entity, (String)prop, (Object)defaultValue);
            }
            catch (Exception e) {
                logger.info("error to set field:" + prop + "default value", (Throwable)e);
            }
        }
        try {
            String id = (String)PropertyUtils.getSimpleProperty((Object)entity, (String)"id");
            if (StringUtils.isBlank((String)id)) {
                PropertyUtils.setSimpleProperty((Object)entity, (String)"id", null);
            }
        }
        catch (Exception ignored) {
            logger.error(ignored.getLocalizedMessage());
        }
    }
}

