/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.impl;

import com.gtis.archive.core.cache.Cache;
import com.gtis.archive.core.dict.Dict;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.support.xstream.CDATASupportDom4JDriver;
import com.gtis.support.hibernate.HibernateDao;
import com.gtis.support.hibernate.HibernateTemplate;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.TransactionException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DictServiceImpl
extends HibernateTemplate<Dict, String>
implements DictService {
    private static final Logger logger = LoggerFactory.getLogger(DictServiceImpl.class);
    public static final String DEFAULT_DICT_FILE = "default-dict.xml";
    private HibernateTemplate<Item, String> itemTemplate;
    @Autowired
    private HibernateTransactionManager transactionManager;
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Dict getDict(String name) {
        return (Dict)this.findUniqueBy("name", (Object)name);
    }

    public Dict getDictById(String id) {
        return (Dict)this.get((Serializable)((Object)id));
    }

    public List<Dict> getDicts() {
        return this.getAll();
    }

    public Item getItem(String itemId) {
        return (Item)this.itemTemplate.get((Serializable)((Object)itemId));
    }

    public List<Item> getItems(String dictName) {
        return this.getItems(dictName, "");
    }

    public List<Item> getItems(String dictName, String parentId) {
        List list = (List)this.cache.get(new Serializable[]{dictName, parentId});
        if (list == null) {
            Dict dict = this.getDict(dictName);
            if (dict == null) {
                throw new EntityNotFoundException("\u5b57\u5178" + dictName + "\u672a\u627e\u5230,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u60a8\u7684\u5b57\u5178\u8bbe\u7f6e");
            }
            Criteria criteria = this.itemTemplate.createCriteria(new Criterion[0]);
            criteria.add((Criterion)Restrictions.eq((String)"dictId", (Object)dict.getId()));
            if (StringUtils.isNotEmpty((String)parentId)) {
                criteria.add((Criterion)Restrictions.eq((String)"parentId", (Object)parentId));
            }
            criteria.addOrder(Order.asc((String)"orderNumber"));
            list = criteria.list();
            this.cache.put((Object)list, new String[]{dictName, parentId});
        }
        return list;
    }

    public List<Item> getItems(String dictName, Object[] params) {
        Dict dict = this.getDict(dictName);
        SQLQuery query = this.getSession().createSQLQuery(dict.getSql());
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param instanceof String) {
                query.setString(i, (String)param);
                continue;
            }
            if (param instanceof Integer) {
                query.setInteger(i, ((Integer)param).intValue());
                continue;
            }
            if (param instanceof Long) {
                query.setLong(i, ((Long)param).longValue());
                continue;
            }
            if (param instanceof Float) {
                query.setFloat(i, ((Float)param).floatValue());
                continue;
            }
            if (param instanceof Double) {
                query.setDouble(i, ((Double)param).doubleValue());
                continue;
            }
            query.setString(i, param.toString());
        }
        ArrayList<Item> items = new ArrayList<Item>();
        List list = query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP).list();
        for (Map map : list) {
            Item item = new Item();
            item.setName(map.get("NAME").toString());
            item.setValue(map.get("VALUE").toString());
            items.add(item);
        }
        return items;
    }

    @Transactional
    public void removeDict(String id) {
        for (Item item : this.getItems(this.getDictById(id).getName())) {
            this.removeItem(item.getId());
        }
        this.delete((Serializable)((Object)id));
        this.cache.removeAll();
    }

    @Transactional
    public void removeItem(String itemId) {
        this.itemTemplate.delete((Serializable)((Object)itemId));
        this.cache.removeAll();
    }

    @Transactional
    public void saveDict(Dict dict) {
        this.save((Object)dict);
        this.cache.removeAll();
    }

    @Transactional
    public void saveItem(Item item) {
        this.itemTemplate.save((Object)item);
        this.cache.removeAll();
    }

    protected void afterSessionFactorySet() {
        this.itemTemplate = new HibernateTemplate((HibernateDao)this, Item.class);
    }

    public synchronized void init() {
        block4: {
            TransactionStatus status = null;
            try {
                status = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                this.initDefaultDict();
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                logger.error("initDefaultDict error", (Throwable)e);
                if (status == null) break block4;
                try {
                    this.transactionManager.rollback(status);
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDefaultDict() {
        XStream sm = new XStream((HierarchicalStreamDriver)new CDATASupportDom4JDriver());
        sm.alias("dict", Dict.class);
        sm.alias("item", Item.class);
        Reader reader = null;
        try {
            reader = new InputStreamReader(this.getClass().getResource(DEFAULT_DICT_FILE).openStream(), "UTF-8");
            Map map = (Map)sm.fromXML(reader);
            for (Map.Entry entry : map.entrySet()) {
                Dict dict = (Dict)entry.getKey();
                if (this.getDict(dict.getName()) != null) continue;
                logger.warn("dict [{}] not found,create it", (Object)dict.getName());
                this.save((Object)dict);
                for (Item item : (List)entry.getValue()) {
                    item.setDictId(dict.getId());
                    this.saveItem(item);
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

