package com.gtis.archive.web.admin.xian;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Creator: Cache John
 * E-mail:550595698@qq.com
 * Date: 11-8-3
 * To change this template use File | Settings | File Templates.
 */
public class KybgAction extends ActionSupport {

    private static final Logger logger = LoggerFactory.getLogger(KybgAction.class);
    private static final long serialVersionUID = 5920816773215902297L;
    private List<Map> kybgs = new ArrayList<Map>();
    protected SessionFactory sessionFactory;
    private String xmmc;
    private String rq1;
    private String rq2;

    @Autowired
    private DictService dictService;

    public List<Map> getKybgs() {
        return kybgs;
    }

    public void setKybgs(List<Map> kybgs) {
        this.kybgs = kybgs;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public String getRq1() {
        return rq1;
    }

    public void setRq1(String rq1) {
        this.rq1 = rq1;
    }

    public String getRq2() {
        return rq2;
    }

    public void setRq2(String rq2) {
        this.rq2 = rq2;
    }

    @Override
    public String execute() throws Exception {
        kybgs = getKybgFormat();
        return SUCCESS;
    }

    public String kybgExcel() throws Exception {
        kybgs = getKybgFormat();
        Struts2Utils.setFileDownloadHeader("可研报表.xls", "xls");
        return "kybgexcel";
    }

    public List<Map> getKybgFormat() throws Exception {
        List<Item> items = dictService.getItems("kybg");

        String sql = "select t1.Id as id ";
        for (int j = 0; j < items.size(); j++) {
            sql += " , (Case When t1.flh='" + items.get(j).getValue() + "' Then  t2.xmmc Else Null End) As xmmc" + (j + 1);
        }
        sql += " from t_archive t1 , t_archive_jsxmkg t2 where  t2.Id=t1.Id ";
        if (items.size() > 0) {
            String temp = " and (";
            for (int l = 0; l < items.size() - 1; l++) {
                temp += "t1.flh='" + items.get(l).getValue() + "' or ";
            }
            if (items.size() > 0) {
                temp += " t1.flh='" + items.get(items.size() - 1).getValue() + "') ";
                sql += temp;
            }
        }
        //匹配条件
        if (StringUtils.isNotBlank(rq1)) {
            sql += " and TO_DATE( '" + rq1 + "','YYYY-MM-DD HH24:MI:SS')<TO_DATE(to_char( t2.BZRQ,'yyyy-mm-dd hh24:mi:ss'),'YYYY-MM-DD HH24:MI:SS') ";
        }
        if (StringUtils.isNotBlank(rq2)) {
            sql += " and TO_DATE( '" + rq2 + "','YYYY-MM-DD HH24:MI:SS')>TO_DATE(to_char( t2.BZRQ,'yyyy-mm-dd hh24:mi:ss'),'YYYY-MM-DD HH24:MI:SS') ";
        }

        sql += "  order By t1.flh";
        SQLQuery query = getSession().createSQLQuery(sql);
        System.out.println(sql);
        List<Map> list = (List<Map>) query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP).list();
        kybgs = dealListFormat(list);
        return kybgs;
    }

    public List<Map> dealListFormat(List<Map> list) throws Exception {
        if (list.size() > 0) {
            if (list.get(0).get("XMMC2") == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get("XMMC2") != null && j > i) {
                            Map map = list.get(i);
                            map.put("XMMC2", list.get(j).get("XMMC2").toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put("XMMC2", null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get("XMMC3") == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get("XMMC3") != null && j > i) {
                            Map map = list.get(i);
                            map.put("XMMC3", list.get(j).get("XMMC3").toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put("XMMC3", null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get("XMMC4") == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get("XMMC4") != null && j > i) {
                            Map map = list.get(i);
                            map.put("XMMC4", list.get(j).get("XMMC4").toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put("XMMC4", null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get("XMMC5") == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get("XMMC5") != null && j > i) {
                            Map map = list.get(i);
                            map.put("XMMC5", list.get(j).get("XMMC5").toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put("XMMC5", null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            for (int i = 0; i < list.size(); i++) {
                if (list.get(i).get("XMMC1") == null
                        && list.get(i).get("XMMC2") == null
                        && list.get(i).get("XMMC3") == null
                        && list.get(i).get("XMMC4") == null
                        && list.get(i).get("XMMC5") == null) {
                    list.remove(i);
                    i--;
                }
            }
            for (int i = 0; i < list.size(); i++) {
                Map map = list.get(i);
                map.put("ID", i + 1);
                list.set(i, map);
            }
            int no1 = 0, no2 = 0, no3 = 0, no4 = 0, no5 = 0;
            for (int i = 0; i < list.size(); i++) {
                if (list.get(i).get("XMMC1") != null) {
                    no1++;
                }
                if (list.get(i).get("XMMC2") != null) {
                    no2++;
                }
                if (list.get(i).get("XMMC3") != null) {
                    no3++;
                }
                if (list.get(i).get("XMMC4") != null) {
                    no4++;
                }
                if (list.get(i).get("XMMC5") != null) {
                    no5++;
                }
            }
            Map map = new HashMap();
            map.put("ID", "数量合计");
            map.put("XMMC1", no1);
            map.put("XMMC2", no2);
            map.put("XMMC3", no3);
            map.put("XMMC4", no4);
            map.put("XMMC5", no5);
            list.add(map);
        }

        return list;
    }

    /**
     * 取得当前Session.
     */
    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(sessionFactory, true);
    }

    /**
     * 取得sessionFactory.
     */
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * 采用@Autowired按类型注入SessionFactory, 当有多个SesionFactory的时候Override本函数.
     */
    @Autowired
    public void setSessionFactory(final SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        afterSessionFactorySet();
    }

    protected void afterSessionFactorySet() {
    }

    public String getTab() {
        return "kybg";
    }
}
