package com.gtis.archive.web.admin;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-6-19 下午3:57
 */
public class MlhAction extends ActionSupport{
    private Logger logger = LoggerFactory.getLogger(MlhAction.class);

    @Autowired
    private SysUserService userService;

    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private ModelService modelService;

    private int start = 0;
    
    private int limit = 30;

    private AjhRange ajhRange;

    private String msg;

    private Map<String, String> modelsMap;



    /**
     * A default implementation that does nothing an returns "success".
     * <p/>
     * Subclasses should override this method to provide their business logic.
     * <p/>
     * See also {@link com.opensymphony.xwork2.Action#execute()}.
     *
     * @return returns {@link #SUCCESS}
     * @throws Exception can be thrown by subclasses.
     */
    @Override
    public String execute() throws Exception {
        modelsMap=new HashMap<String, String>();
        for (Model model : modelService.getModels()) {
            modelsMap.put(model.getName(),model.getTitle());
        }
        return super.execute();
    }

    public String list(){
        Order[] orders = new Order[3];
        orders[0] = Order.asc("dwdm");
        orders[1] = Order.asc("modelName");
        orders[2] = Order.asc("mlh");
        try{
            if(EnvHolder.isEnable(Switch.JIANGYIN)){
                Page<AjhRange> ajhRanges = ajhRangeService.getAjhRangesOrderMlh(start, limit, "asc");
                Struts2Utils.renderJson(ajhRanges);
            }else{
                Page<AjhRange> ajhRanges = ajhRangeService.getAjhRanges(start, limit, orders);
                Struts2Utils.renderJson(ajhRanges);
            }
        }catch (Exception ex){
            Struts2Utils.renderJson(new Page());
        }
        return null;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setAjhRange(AjhRange ajhRange){
        this.ajhRange=ajhRange;
    }

    public AjhRange getAjhRange(){
        return this.ajhRange;
    }

    public String getMsg(){
        return this.msg;
    }


    public String getTab(){
        return "mlh";
    }

    public List<String> getModels(){
        List<String> list=new ArrayList<String>();
       for (Model model:modelService.getModels()){
           list.add(model.getName());
       }
        return list;
    }

    public String getModelsMap() {
       return JSON.toJSON(modelsMap).toString();
    }

    public String edit() throws Exception{
        if(ajhRange!=null){
            if (ajhRange.getCurrentValue() < ajhRange.getMinValue())
                ajhRange.setCurrentValue(ajhRange.getMinValue());
            if (StringUtils.isBlank(ajhRange.getId())) {
                ajhRange.setId(null);
            }
            if(ajhRange.getModelName().indexOf(",")==0){
                ajhRange.setModelName(ajhRange.getModelName().substring(1,ajhRange.getModelName().length()));
            }
            StringBuilder sb=new StringBuilder();
            String[] models=ajhRange.getModelName().split(",");
            List<String> list=new LinkedList<String>();
            for(String model:models){
                   if(!list.contains(model.trim()))
                       list.add(model.trim());
            }
            for(int i=0;i<list.size();i++){
                if(i==list.size()-1){
                    sb.append(list.get(i));
                }else {
                    sb.append(list.get(i)+",");
                }
            }
            ajhRange.setModelName(sb.toString());
            ajhRangeService.saveAjhRange(ajhRange);
            msg = "successed";
        }
        return "edit";
    }

    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
