package com.gtis.archive.web.admin;

import com.gtis.archive.core.dict.Dict;
import com.gtis.archive.core.dict.DictService;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-1
 */
public class DictAction extends ActionSupport {
    private static final long serialVersionUID = 6260137672501293993L;
    @Autowired
    private DictService dictService;

    private String id;
    private Dict dict;
    private List<Dict> dicts;
    private String msg;

    public Dict getDict() {
        return dict;
    }

    public void setDict(Dict dict) {
        this.dict = dict;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMsg() {
        return msg;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    public String edit() throws Exception {
        if (dict == null) {
            if (StringUtils.isNotBlank(id)) {
                dict = dictService.getDictById(id);
            } else {
                dict = new Dict();
            }
        } else {
            if (StringUtils.isBlank(dict.getName()))
                return "edit";
            if (StringUtils.isBlank(dict.getId())) {
                if (dictService.getDict(dict.getName()) != null) {
                    msg = "existed";
                    return "edit";
                }
            }
            dictService.saveDict(dict);
            msg = "successed";
        }
        return "edit";
    }

    public List<Dict> getDicts() {
        return dictService.getDicts();
    }

    public String getTab() {
        return "dict";
    }

    public String remove() throws Exception {
        dictService.removeDict(id);
        return "toIndex";
    }
}
