package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
public class GatewayAction implements Action {

    @Autowired
    private GatewayService gatewayService;

    @Autowired
    private DictService dictService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    protected ModelService modelService;

    private String data;

    private String id;

    private String modelName;

    private String mlh;  //目录号

    private Map docShowFields;
    private Map docFields;

    private String tm;

    /**
     * 链接字段
     */
    private String linkField;

    /**
     * 列表要显示的字段
     */
    private Map showFields;

    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    /**
     * 获取案卷是否存在卷内
     * @return
     */
    public boolean getIsShowArchiveDoc(){
        try{
            if(modelService.getModel(modelName.concat("_jn")) != null){
                return true;
            }

        }catch (ModelNotFoundException ex){
            return false;
        }
        return false;
    }

    /**
     * 获取字段列表
     *
     * @return 字段列表
     */
    public Map<String, Field> getFields() {
        return getEntityModel().getInheritfieldsMap();
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = URLDecoder.decode(tm);
    }

    /**
     * 默认插入档案
     *
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        if (StringUtils.isNotBlank(data))
            Struts2Utils.renderXml(gatewayService.in(data));
        return null;
    }

    /**
     * 更新档案
     *
     * @return
     */
    public String update() {
        if (StringUtils.isNotBlank(data)) {
            Struts2Utils.renderXml(gatewayService.update(data));
        }
        return null;
    }

    /**
     *
     * @return
     * @throws Exception
     */
    public String preIn() throws Exception{
        if(StringUtils.isNotBlank(data))
            Struts2Utils.renderXml(gatewayService.preIn(data));
        return null;
    }

    /**
     *    预处理
     * @return
     */
    public String preDispose(){
        try{
            gatewayService.preDispose(modelName,id,mlh);
            Struts2Utils.renderJson("success");
        }catch (Exception ex){
            Struts2Utils.renderJson(ex.toString());
        }
        return null;
    }

    /**
     * 撤销预处理
     * @return
     */
    public String cancelDispose(){
        try{
            gatewayService.cancelDispose(modelName,id);
            Struts2Utils.renderJson("success");
        }catch (Exception ex){

        }
        return null;
    }


    /**
     * 打印完交接单在档案列表中显示
     * @return
     */
    public String dispose(){
        try{
            Struts2Utils.renderJson(gatewayService.dispose(modelName,id));
        }catch (Exception ex){
            Struts2Utils.renderJson(ex.toString());
        }
        return null;
    }

    public String edit() {
        return "edit";
    }

    public String originalInfo(){
        return "originalInfo";
    }

    public String originalInfoByTm() throws IOException {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Order> orders = new ArrayList<Order>();
        Archive archive = null;

        criterions.add(Restrictions.like("tm","%" + tm +"%"));
        List archives = archiveService.searchArchiveList(modelName, criterions,orders,-1,-1);

        if(archives.size()>=1){
            archive = (Archive)archives.get(0);
            setId(archive.getId());
        }else {
            setId("");
        }

        return "originalInfo";
    }

    public String inBox(){
        return "inBox";
    }

    public String list(){
        Archive archive=archiveService.getArchive(modelName, id);
        return "list";
    }

    public String out(){
        if(StringUtils.isNotBlank(id)&&StringUtils.isNotBlank(modelName))
            Struts2Utils.renderXml(gatewayService.out(id,modelName));
        else if(StringUtils.isNotBlank(id))
            Struts2Utils.renderXml(gatewayService.out(id));
        return null;
    }



    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public String getId() {
        return id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }


    public Map getDocShowFields() {
        if(docShowFields==null)
        {
            try{
                Model doc = archiveService.getDocumentModel(modelName+"_jn");
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            }catch(ModelNotFoundException ex){
            }catch(TemplateNotFoundException ex){
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"),LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    public Map getDocFields(){
        if(docFields==null){
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            }catch(ModelNotFoundException ex){
            }
        }
        return docFields;
    }

    private String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return modelService.getModel(modelName);
    }


    public String getList(){
        Collection<Model> models=getModels();
        Map<String,String> map=new HashMap<String,String>();
        Iterator iterator=models.iterator();
        while (iterator.hasNext()){
            Model model=(Model)iterator.next();
            if("Archive".equals(model.getParentName()))
                map.put(model.getTitle(),model.getName());
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys(){
        Collection<Model> models=getModels();
        ArrayList<String> keys=new ArrayList<String>();
        Iterator iterator=models.iterator();
        while (iterator.hasNext()){
            Model model=(Model)iterator.next();
            if("Archive".equals(model.getParentName()))
                keys.add(model.getTitle());
        }
        return keys;
    }


    public Collection<Model> getModels() {
        return modelService.getModels();
    }

}
