package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.ArchiveInfo;
import com.gtis.archive.service.ArchiveService;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelonXu</a>
 * @version V1.0, 12-5-18 上午9:27
 */
public class ArchiveinfoEntityAction extends BaseEntityAction<ArchiveInfo>{

    @Autowired
    private ArchiveService archiveService;

    private String archiveId;
    
    private String archiveModel;

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    @Override
    public void prepare() {
        entity = entityService.query(modelName, Restrictions.eq("archiveId", archiveId));
        if(entity==null)
            entity = entityService.newInstance(modelName);
        entity.setArchive(archiveService.getArchive(archiveModel,archiveId));
    }

    @Override
    protected String getJsCallBack() {
        return "archiveInfoComplete";
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getArchiveModel() {
        return archiveModel;
    }

    public void setArchiveModel(String archiveModel) {
        this.archiveModel = archiveModel;
    }

    private String toAIModelName(String name){
        if(name.endsWith("_ai"))
            return name;
        else if(name.lastIndexOf("_ai")<0)
            return name.concat("_ai");
        return name;
    }
}
