package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>
 * 元数据
 * Generated 2011-10-22 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_metadata")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Metadata {
    public static final String MODEL_NAME = Metadata.class.getSimpleName();
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 主题
     */
    @Column(length = 1000)
    private String subject;

    /**
     * 正题名
     */
    @Column(length = 100)
    private String ztm;

    /**
     * 责任者实体
     */
    @Column(length = 100)
    private String creator;

    /**
     * 创建日期
     */
    private Date creationDate;

    /**
     * 登记日期
     */
    private Date registrationDate;

    /**
     * 存取时间
     */
    private Date accessDate;

    /**
     * 传输日期
     */
    private Date transferingDate;

    /**
     * 到期日期
     */
    private Date dueDate;

    /**
     * 处置日期
     */
    private Date disposalDate;

    /**
     * 媒体格式
     */
    @Column(length = 100)
    private String mediaFormat;

    /**
     * 文件摘要
     */
    @Column(length = 1000)
    private String recordAbstract;

    /**
     * 文件语种
     */
    @Column(length = 100)
    private String language;

    /**
     * 稿本
     */
    @Column(length = 100)
    private String manuscript;

    /**
     * 业务处理过程
     */
    @Column(length = 1000)
    private String functionHistory;

    /**
     * 业务法规依据
     */
    @Column(length = 100)
    private String functionMandate;

    /**
     * 业务标识
     */
    @Column(length = 100)
    private String functionIdentifier;

    /**
     * 描述
     */
    @Column(length = 1000)
    private String description;

    /**
     * 档案序号
     */
    @Column(length = 32)
    private String archiveId;

    @Transient
    private Archive archive;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getZtm() {
        return ztm;
    }

    public void setZtm(String ztm) {
        this.ztm = ztm;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getRegistrationDate() {
        return registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public Date getAccessDate() {
        return accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    public Date getTransferingDate() {
        return transferingDate;
    }

    public void setTransferingDate(Date transferingDate) {
        this.transferingDate = transferingDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getDisposalDate() {
        return disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public String getMediaFormat() {
        return mediaFormat;
    }

    public void setMediaFormat(String mediaFormat) {
        this.mediaFormat = mediaFormat;
    }

    public String getRecordAbstract() {
        return recordAbstract;
    }

    public void setRecordAbstract(String recordAbstract) {
        this.recordAbstract = recordAbstract;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getManuscript() {
        return manuscript;
    }

    public void setManuscript(String manuscript) {
        this.manuscript = manuscript;
    }

    public String getFunctionHistory() {
        return functionHistory;
    }

    public void setFunctionHistory(String functionHistory) {
        this.functionHistory = functionHistory;
    }

    public String getFunctionMandate() {
        return functionMandate;
    }

    public void setFunctionMandate(String functionMandate) {
        this.functionMandate = functionMandate;
    }

    public String getFunctionIdentifier() {
        return functionIdentifier;
    }

    public void setFunctionIdentifier(String functionIdentifier) {
        this.functionIdentifier = functionIdentifier;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public Archive getArchive() {
        return archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }
}