package com.gtis.archive.core.environment;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-4
 */
public class EnvironmentConverter extends MapConverter {
    public EnvironmentConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Environment env = (Environment) source;
        super.marshal(env.getProps(), writer, context);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Environment env = (Environment) createCollection(context.getRequiredType());
        populateMap(reader, context, env.getProps());
        return env;
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Environment.class);
    }
}
