package com.gtis.archive.web.admin;

import com.gtis.archive.Constants;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.PermissionService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">Administrator</a>
 * @version V1.0, 2010-12-9
 */
public class PermissionAction extends ActionSupport {
    private static final long serialVersionUID = -3107528495499282167L;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private DictService dictService;

    private List<PfRoleVo> roles;
    private String treeJson;
    private String roleId;
    private String[] checked;
    private String[] unChecked;

    private Set<Permission> permissions = new HashSet<Permission>();
    private List<Item> operations; //item存放所有定义的操作项

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                List<Map<String, Object>> opts = new ArrayList<Map<String, Object>>();
                for (Item item : operations) {
                    Map<String, Object> op = new HashMap<String, Object>();
                    op.put("name", id + "_" + item.getName());
                    op.put("text", item.getValue());
                    op.put("checked", permissions.contains(new Permission(id, roleId, item.getName())));
                    opts.add(op);
                }
                map.put("data", opts);
            }
        }
        return tree;
    }

    public void setUnChecked(String[] unChecked) {
        this.unChecked = unChecked;
    }

    public void setChecked(String[] checked) {
        this.checked = checked;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public List<PfRoleVo> getRoles() {
        return roles;
    }

    public String getTreeJson() {
        return treeJson;
    }

    @Override
    public String execute() throws Exception {
        roles = userService.getRoleList();
        return SUCCESS;
    }

    public String tree() throws Exception {
        permissions.addAll(permissionService.getPermissions(null, roleId));
        operations = dictService.getItems(Permission.OPERATION_DICT);
        List<Map<String, Object>> tree = rewrite(treeService.getTree(null, Constants.MODEL_ROOT));
        tree.add(0, getSysFunctionNode());
        treeJson = JSONUtil.serialize(tree);
        return "tree";
    }

    private Map<String, Object> getSysFunctionNode() {
        List<Item> sysFunction = dictService.getItems(Permission.SYS_FUNCTION_DICT);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", "sys");
        map.put("text", "系统功能");
        map.put("leaf", true);
        map.put("iconCls", "node");
        List<Map<String, Object>> functions = new ArrayList<Map<String, Object>>();
        for (Item item : sysFunction) {
            Map<String, Object> op = new HashMap<String, Object>();
            op.put("name", "sys_" + item.getName());
            op.put("text", item.getValue());
            op.put("checked", permissions.contains(new Permission("sys", roleId, item.getName())));
            functions.add(op);
        }
        map.put("data", functions);
        return map;
    }

    public String save() throws Exception {
        if (checked != null && StringUtils.isNotBlank(checked[0])) {
            Permission[] ps = new Permission[checked.length];
            for (int i = 0, len = checked.length; i < len; i++) {
                ps[i] = toPermission(checked[i], roleId);
            }
            permissionService.grant(ps);
        }
        if (unChecked != null && StringUtils.isNotBlank(unChecked[0])) {
            Permission[] ps = new Permission[unChecked.length];
            for (int i = 0, len = unChecked.length; i < len; i++) {
                ps[i] = toPermission(unChecked[i], roleId);
            }
            permissionService.revoke(ps);
        }
        return null;
    }

    private static Permission toPermission(String s, String roleId) {
        String[] ss = s.split("_");
        return new Permission(ss[0], roleId, ss[1]);
    }

    public String getTab() {
        return "permission";
    }
}
